# Copyright (c) 2023 PAL Robotics S.L. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import os

from launch import LaunchDescription
from launch_ros.actions import Node
from ament_index_python.packages import get_package_share_directory


def generate_launch_description():

    gravity_spawner_node = Node(
        package='controller_manager',
        executable='spawner',
        arguments=[
            "gravity_compensation_controller", "--param-file", os.path.join(
                get_package_share_directory('tiago_controller_configuration'),
                'config', 'gravity_compensation_controller.yaml'),
            "--controller-type", "pal_controllers/GravityCompensationController", "--inactive"],
    )

    ld = LaunchDescription()
    ld.add_action(gravity_spawner_node)
    return ld
