# Copyright (c) 2023 PickNik, Inc.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# Author: Lovro Ivanov
#
# Description: After a robot has been loaded, this will execute a series of trajectories.

from launch import LaunchDescription
from launch.substitutions import PathJoinSubstitution
from launch_ros.actions import Node
from launch_ros.substitutions import FindPackageShare


def generate_launch_description():

    test_params = PathJoinSubstitution(
        [
            FindPackageShare("kortex_bringup"),
            "config",
            "test_huge_joint_space_jump_config.yaml",
        ]
    )

    return LaunchDescription(
        [
            Node(
                package="kortex_bringup",
                executable="test_huge_joint_space_jump.py",
                name="test_huge_joint_space_jump",
                parameters=[test_params],
                output={
                    "stdout": "screen",
                    "stderr": "screen",
                },
            )
        ]
    )
