// *****************************************************************************
//
// Copyright (c) 2014-2020, Southwest Research Institute® (SwRI®)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS__POINT_CLICK_PUBLISHER_PLUGIN_H_
#define MAPVIZ_PLUGINS__POINT_CLICK_PUBLISHER_PLUGIN_H_

// Include mapviz_plugin.h first to ensure GL deps are included in the right order
#include <mapviz/mapviz_plugin.h>

#include <QGLWidget>
#include <QTimer>
#include <mapviz/map_canvas.h>

#include <mapviz_plugins/canvas_click_filter.h>

#include <rclcpp/rclcpp.hpp>

#include <geometry_msgs/msg/point_stamped.hpp>

// C++ Standard Libraries
#include <string>

// QT autogenerated files
#include "ui_point_click_publisher_config.h"
#include "ui_topic_select.h"

/**
 * This is a pretty straightforward plugin.  It watches for user clicks on the
 * canvas, then converts the coordinates into a specified frame and publishes
 * them as PointStamped messages on a specified topic.
 */
namespace mapviz_plugins
{
class PointClickPublisherPlugin : public mapviz::MapvizPlugin
{
  Q_OBJECT;
public:
  PointClickPublisherPlugin();
  ~PointClickPublisherPlugin() override;

  bool Initialize(QGLWidget* canvas) override;
  void Shutdown() override {}

  void SetNode(rclcpp::Node& node) override;
  void PrintError(const std::string& message) override;
  void PrintInfo(const std::string& message) override;
  void PrintWarning(const std::string& message) override;

  void Draw(double x, double y, double scale) override;

  void Transform() override {}

  void LoadConfig(const YAML::Node& node, const std::string& path) override;
  void SaveConfig(YAML::Emitter& emitter, const std::string& path) override;

  QWidget* GetConfigWidget(QWidget* parent) override;

protected Q_SLOTS:
  void pointClicked(const QPointF& point);
  void topicChanged(const QString& topic);
  void updateFrames();

private:
  Ui::point_click_publisher_config ui_{};
  QWidget* config_widget_;

  CanvasClickFilter click_filter_;
  mapviz::MapCanvas* canvas_;

  QTimer frame_timer_;
  rclcpp::Publisher<geometry_msgs::msg::PointStamped>::SharedPtr point_publisher_;
};
}   // namespace mapviz_plugins

#endif  // MAPVIZ_PLUGINS__POINT_CLICK_PUBLISHER_PLUGIN_H_
