// *****************************************************************************
//
// Copyright (c) 2014-2020, Southwest Research Institute® (SwRI®)
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Southwest Research Institute® (SwRI®) nor the
//       names of its contributors may be used to endorse or promote products
//       derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
// LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
// ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
// SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
// *****************************************************************************

#ifndef MAPVIZ_PLUGINS__ROBOT_IMAGE_PLUGIN_H_
#define MAPVIZ_PLUGINS__ROBOT_IMAGE_PLUGIN_H_

#include <mapviz/mapviz_plugin.h>

// QT libraries
#include <QGLWidget>
#include <QObject>
#include <QWidget>

// ROS libraries
#include <rclcpp/rclcpp.hpp>
#include <tf2/transform_datatypes.h>

#include <mapviz/map_canvas.h>

// C++ standard libraries
#include <string>

// QT autogenerated files
#include "ui_robot_image_config.h"
#include "ui_topic_select.h"

namespace mapviz_plugins
{
class RobotImagePlugin : public mapviz::MapvizPlugin
{
  Q_OBJECT

public:
  RobotImagePlugin();
  ~RobotImagePlugin() override = default;

  bool Initialize(QGLWidget* canvas) override;
  void Shutdown() override {}

  void Draw(double x, double y, double scale) override;

  void Transform() override;

  void LoadConfig(const YAML::Node& node, const std::string& path) override;
  void SaveConfig(YAML::Emitter& emitter, const std::string& path) override;

  QWidget* GetConfigWidget(QWidget* parent) override;

protected:
  void PrintError(const std::string& message) override;
  void PrintInfo(const std::string& message) override;
  void PrintWarning(const std::string& message) override;

protected Q_SLOTS:
  void SelectFile();
  void SelectFrame();
  void FrameEdited();
  void ImageEdited();
  void WidthChanged(double value);
  void HeightChanged(double value);
  void OffsetXChanged(double value);
  void OffsetYChanged(double value);
  void RatioEqualToggled(bool toggled);
  void RatioCustomToggled(bool toggled);
  void RatioOriginalToggled(bool toggled);

private:
  Ui::robot_image_config ui_;
  QWidget* config_widget_;

  double width_;  // image width, if robot frame is x-forward this corresponds to robot length
  double height_;   // image height, corresponds to robot width
  double offset_x_;   // offset of image center from robot frame along x axis
  double offset_y_;   // offset of image center from robot frame along y axis
  double image_ratio_;

  std::string filename_;
  QImage      image_;
  int dimension_;
  int texture_id_;
  bool texture_loaded_;

  bool transformed_;

  tf2::Vector3 top_left_;
  tf2::Vector3 top_right_;
  tf2::Vector3 bottom_left_;
  tf2::Vector3 bottom_right_;

  tf2::Vector3 top_left_transformed_;
  tf2::Vector3 top_right_transformed_;
  tf2::Vector3 bottom_left_transformed_;
  tf2::Vector3 bottom_right_transformed_;

  void UpdateShape();
  void LoadImage();
};
}   // namespace mapviz_plugins

#endif  // MAPVIZ_PLUGINS__ROBOT_IMAGE_PLUGIN_H_
