/*********************************************************************
 * Software License Agreement (BSD License)
 *
 *  Copyright (c) 2022, Metro Robots
 *  All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.
 *   * Neither the name of Metro Robots nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 *  COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 *  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 *  CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 *  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 *  ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 *********************************************************************/

/* Author: David V. Lu!! */
#include <moveit_setup_app_plugins/launches.hpp>

namespace moveit_setup
{
namespace app
{
void Launches::onInit()
{
  config_data_->registerType("launches", "moveit_setup::app::LaunchesConfig");
  launches_config_ = config_data_->get<LaunchesConfig>("launches");

  available_launch_bundles_.push_back(
      LaunchBundle("Robot State Publisher Launch",
                   "Launch file to publish the robot description and transforms generated by the joint states.", "rsp",
                   { "robot_state_publisher" }));
  available_launch_bundles_.push_back(
      LaunchBundle("RViz Launch and Config",
                   "Visualize in Rviz the robot's planning groups running with interactive "
                   "markers that allow goal states to be set.",
                   "moveit_rviz", { "rviz2", "rviz_common", "rviz_default_plugins", "moveit_ros_visualization" }));
  available_launch_bundles_.back().addFile(
      "config/moveit.rviz", "Configuration file for Rviz with the Motion Planning Plugin already setup.");
  available_launch_bundles_.push_back(LaunchBundle(
      "MoveGroup Launch", "Launch file to run the main MoveIt executable that provides the MoveGroup action",
      "move_group", { "moveit_ros_move_group" }));
  available_launch_bundles_.push_back(LaunchBundle("Static TF Launch",
                                                   "Launch file to broadcast static TF for the robot's virtual joints.",
                                                   "static_virtual_joint_tfs", { "tf2_ros" }));
  available_launch_bundles_.push_back(LaunchBundle("Spawn Controllers Launch",
                                                   "Launch file to spawn the necessary controllers",
                                                   "spawn_controllers", { "controller_manager" }));
  available_launch_bundles_.push_back(LaunchBundle("Demo Launch",
                                                   "Launch file to run a demo of MoveGroup. Warning that it requires "
                                                   "the above launch files to all be generated as well.",
                                                   "demo"));

  available_launch_bundles_.push_back(LaunchBundle("Setup Assistant Launch",
                                                   "Launch file for easily re-starting the MoveIt "
                                                   "Setup Assistant to edit this robot's generated "
                                                   "configuration package.",
                                                   "setup_assistant", { "moveit_setup_assistant" }));
  available_launch_bundles_.push_back(LaunchBundle("Warehouse DB Launch",
                                                   "Launch file for starting the warehouse with a default MongoDB.",
                                                   "warehouse_db", { "warehouse_ros_mongo", "moveit_ros_warehouse" }));

  for (unsigned int i = 0; i < available_launch_bundles_.size(); i++)
  {
    available_launch_bundles_[i].setID(i);

    // By default, we start with all the launch bundles included
    launches_config_->include(available_launch_bundles_[i]);
  }
}

bool Launches::getState(unsigned int id) const
{
  return launches_config_->isIncluded(available_launch_bundles_[id]);
}

void Launches::setState(unsigned int id, bool state)
{
  const LaunchBundle& bundle = available_launch_bundles_[id];
  if (state)
  {
    launches_config_->include(bundle);
  }
  else
  {
    launches_config_->remove(bundle);
  }
}
}  // namespace app
}  // namespace moveit_setup
