/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.parser.typecode;

import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.util.Pair;
import org.antlr.stringtemplate.StringTemplate;

public class StringTypeCode
extends TypeCode {
    private String m_maxsize = null;

    public StringTypeCode(int kind, String maxsize) {
        super(kind);
        this.m_maxsize = maxsize;
    }

    @Override
    public boolean isIsType_d() {
        return true;
    }

    @Override
    public String getTypeIdentifier() {
        switch (this.getKind()) {
            case 13: {
                return "TI_STRING8_SMALL";
            }
            case 21: {
                return "TI_STRING16_SMALL";
            }
        }
        return "TK_None";
    }

    @Override
    public boolean isPlainType() {
        return true;
    }

    @Override
    public boolean isIsStringType() {
        return this.getKind() == 13;
    }

    @Override
    public boolean isIsWStringType() {
        return this.getKind() == 21;
    }

    @Override
    public String getCppTypename() {
        return this.getCppTypenameFromStringTemplate().toString();
    }

    @Override
    public String getCTypename() {
        StringTemplate st = this.getCTypenameFromStringTemplate();
        st.setAttribute("maxsize", this.getMaxsize());
        return st.toString();
    }

    @Override
    public String getJavaTypename() {
        return this.getJavaTypenameFromStringTemplate().toString();
    }

    @Override
    public String getIdlTypename() {
        return this.getIdlTypenameFromStringTemplate().toString();
    }

    @Override
    public String getInitialValue() {
        return this.getInitialValueFromStringTemplate();
    }

    @Override
    public String getMaxsize() {
        if (this.m_maxsize == null) {
            return "255";
        }
        return this.m_maxsize;
    }

    public Pair<Integer, Integer> getMaxSerializedSize(int currentSize, int lastDataAligned) {
        int lcurrentSize = currentSize;
        if (4 <= lastDataAligned) {
            lcurrentSize += 4;
        } else {
            int align = 4 - lcurrentSize % 4 & 3;
            lcurrentSize += 4 + align;
        }
        if (this.m_maxsize == null) {
            return new Pair<Integer, Integer>(lcurrentSize + 255 + 1, 1);
        }
        return new Pair<Integer, Integer>(lcurrentSize + Integer.parseInt(this.m_maxsize) + 1, 1);
    }

    public int getMaxSerializedSizeWithoutAlignment(int currentSize) {
        if (this.m_maxsize == null) {
            return currentSize + 4 + 255 + 1;
        }
        return currentSize + 4 + Integer.parseInt(this.m_maxsize) + 1;
    }
}

