(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     19483,        573]
NotebookOptionsPosition[     17110,        526]
NotebookOutlinePosition[     17504,        542]
CellTagsIndexPosition[     17461,        539]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Ruckig: OTG with constrained Jerk, Zero Target Velocity", "Text",
 CellChangeTimes->{{3.812333727449677*^9, 3.812333730908003*^9}, {
  3.8123837241868753`*^9, 3.812383728276732*^9}, {3.814008457214835*^9, 
  3.814008475537912*^9}, {3.817472011010562*^9, 
  3.817472011384983*^9}},ExpressionUUID->"6747c71c-c66c-433d-9613-\
bddcf8a50059"],

Cell["\<\
For Case 8 and v0 == 0 AND a0 == 0 AND vf==0. Redo 3rd-root as one.\
\>", "Text",
 CellChangeTimes->{{3.8146051660859423`*^9, 3.8146051676141644`*^9}, {
  3.8147687750458*^9, 3.814768780413946*^9}, {3.814768843942274*^9, 
  3.8147688443024693`*^9}, {3.814769106344132*^9, 3.8147691264322968`*^9}, {
  3.815374392258692*^9, 
  3.815374394154854*^9}},ExpressionUUID->"9c0ba946-2fb4-4a4b-a305-\
4d0102c9636e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"0", "+", 
    RowBox[{"t1", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a3", "=", 
   RowBox[{"a1", "+", 
    RowBox[{"t3", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a5", "=", 
   RowBox[{"a3", "+", 
    RowBox[{"t5", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a7", "=", 
    RowBox[{"a5", "+", 
     RowBox[{"t7", " ", 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"0", "+", 
    RowBox[{"t1", " ", "0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"v1", "+", 
    RowBox[{"t3", " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v5", "=", 
   RowBox[{"v3", "+", 
    RowBox[{"t5", " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v7", "=", 
    RowBox[{"v5", "+", 
     RowBox[{"t7", " ", "a5"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox["t7", "2"], 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"p0", "+", 
    RowBox[{"t1", " ", "0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], " ", "0"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t1", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"p1", "+", 
    RowBox[{"t3", " ", "v1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t3", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"p3", "+", 
    RowBox[{"t5", " ", "v3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t5", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"p5", "+", 
    RowBox[{"t7", " ", "v5"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t7", "2"], " ", "a5"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t7", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.812427566658496*^9, 3.812427632907652*^9}, {
   3.8146051288228292`*^9, 3.8146051320782537`*^9}, {3.814605833195565*^9, 
   3.8146058467073*^9}, 3.814606100135058*^9, {3.814606461947022*^9, 
   3.81460646488223*^9}, {3.814768818295343*^9, 3.814768841182714*^9}},
 CellLabel->
  "In[762]:=",ExpressionUUID->"01d94644-43f4-4ebf-b9dd-650c0bcc93aa"],

Cell[BoxData[
 RowBox[{
  RowBox[{"resultT2", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"a7", "\[Equal]", "0"}], ",", 
       RowBox[{"v7", "\[Equal]", "0"}], ",", 
       RowBox[{"p7", "\[Equal]", "pf"}], ",", 
       RowBox[{"a3", "\[Equal]", "0"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t1", ",", "t3", ",", "t5", ",", "t7"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.812427642111352*^9, 3.812427665374312*^9}, {
   3.814605154673225*^9, 3.814605156526219*^9}, {3.814605231304027*^9, 
   3.8146052323028183`*^9}, 3.814605884924234*^9, {3.8146059229329042`*^9, 
   3.814605932484119*^9}, 3.814768793110735*^9, {3.8151616232829103`*^9, 
   3.815161667622699*^9}, {3.817471867294842*^9, 3.817471879911167*^9}},
 CellLabel->
  "In[778]:=",ExpressionUUID->"ccac5833-2cc2-4703-8af2-4673d2c0a437"],

Cell["Brake Conditions", "Text",
 CellChangeTimes->{{3.815301060071776*^9, 
  3.815301062632262*^9}},ExpressionUUID->"f1f1d133-d9ee-48d8-ab08-\
fdb8b843aed9"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"v", "[", "t_", "]"}], ":=", 
   RowBox[{"v0", "+", 
    RowBox[{"a0", " ", "t"}], "+", 
    RowBox[{
     FractionBox["1", "2"], "jMax", " ", 
     SuperscriptBox["t", "2"]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "t_", "]"}], ":=", 
   RowBox[{"a0", "+", 
    RowBox[{"jMax", " ", "t"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.815301071602737*^9, 3.8153011217035503`*^9}, {
  3.815301154801783*^9, 3.8153011643431473`*^9}, {3.815302305333596*^9, 
  3.815302308138749*^9}},
 CellLabel->
  "In[122]:=",ExpressionUUID->"e9b3b786-2ee6-4ad4-90fe-0843f9a56019"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], "\[Equal]", "vMax"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.815301471460462*^9, 3.815301490538836*^9}, {
  3.815301983086012*^9, 3.815302024549939*^9}, {3.8153022528546124`*^9, 
  3.815302254242443*^9}, {3.815302298637886*^9, 3.815302320777072*^9}},
 CellLabel->
  "In[124]:=",ExpressionUUID->"635600fe-01e0-4d25-8184-067440ee5de9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "a0"}], "-", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a0", "2"], "-", 
         RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
         RowBox[{"2", " ", "jMax", " ", "vMax"}]}]]}], "jMax"]}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "a0"}], "+", 
       SqrtBox[
        RowBox[{
         SuperscriptBox["a0", "2"], "-", 
         RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
         RowBox[{"2", " ", "jMax", " ", "vMax"}]}]]}], "jMax"]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.815301490911626*^9, {3.815301994594905*^9, 3.8153020101432133`*^9}, 
   3.815302254650476*^9, {3.815302299835743*^9, 3.815302321158864*^9}, 
   3.815385676784521*^9},
 CellLabel->
  "Out[124]=",ExpressionUUID->"778a3e8d-bcc9-4cbe-a256-9baed7c1507e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "[", "t", "]"}], "/.", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"a", "[", "t", "]"}], "\[Equal]", "0"}], ",", "t"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.815301653860085*^9, 3.81530166410566*^9}, {
  3.8153022592708387`*^9, 3.815302267730206*^9}},
 CellLabel->
  "In[125]:=",ExpressionUUID->"75407e54-a918-40b0-94a0-d82634d676e5"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     SuperscriptBox["a0", "2"], 
     RowBox[{"2", " ", "jMax"}]]}], "+", "v0"}], "}"}]], "Output",
 CellChangeTimes->{
  3.8153016643849382`*^9, {3.815302260992894*^9, 3.815302268018663*^9}, 
   3.815302311068635*^9, 3.815385677960538*^9},
 CellLabel->
  "Out[125]=",ExpressionUUID->"a84f9442-a454-4874-ae35-b8c5c8fbc207"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox[
        RowBox[{"a", "[", "t", "]"}], "2"], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "jMax"}]]}], "+", "v0"}], "\[Equal]", 
    RowBox[{"-", "vMax"}]}], ",", "t"}], "]"}]], "Input",
 CellChangeTimes->{{3.815302521676898*^9, 3.815302588738796*^9}, 
   3.815303518987308*^9, {3.815385680582396*^9, 3.815385823183427*^9}, {
   3.8153859268729763`*^9, 3.815385991192477*^9}, {3.815386133297381*^9, 
   3.8153861860585957`*^9}, {3.8153864300841503`*^9, 3.815386432043502*^9}},
 CellLabel->
  "In[169]:=",ExpressionUUID->"8efb60ef-a462-475b-8ff5-e51b2c982b76"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "a0"}], "-", 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "jMax"}], " ", "v0"}], "-", 
          RowBox[{"jMax", " ", "vMax"}]}]]}]}], "jMax"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "a0"}], "+", 
       RowBox[{
        SqrtBox["2"], " ", 
        SqrtBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "jMax"}], " ", "v0"}], "-", 
          RowBox[{"jMax", " ", "vMax"}]}]]}]}], "jMax"]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.815302543863489*^9, 3.815302548690042*^9}, 
   3.815302581860752*^9, 3.8153035193545303`*^9, {3.8153856737850246`*^9, 
   3.815385823879335*^9}, {3.815385927501169*^9, 3.8153859915521183`*^9}, {
   3.815386133777218*^9, 3.815386186730319*^9}, {3.815386430556628*^9, 
   3.815386432429397*^9}},
 CellLabel->
  "Out[169]=",ExpressionUUID->"f3046318-00c5-4e1d-967a-6f60d1eb4324"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"v0", "+", 
      RowBox[{"a0", " ", "t"}], "+", 
      RowBox[{
       FractionBox["1", "2"], "jMax", " ", 
       SuperscriptBox["t", "2"]}]}], "\[Equal]", "vMax"}], ",", "t"}], "]"}], 
  "//.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a0", "\[Rule]", "aMax"}], ",", 
    RowBox[{"v0", "\[Rule]", 
     RowBox[{"-", "0.585176"}]}], ",", 
    RowBox[{"vMax", "\[Rule]", "0.18"}], ",", 
    RowBox[{"aMax", "\[Rule]", "1.3"}], ",", 
    RowBox[{"jMax", "\[Rule]", "6.8"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8153861907135763`*^9, 3.81538630616269*^9}},
 CellLabel->
  "In[167]:=",ExpressionUUID->"38121ff9-6236-4cfd-98df-aef065814608"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", 
     RowBox[{"-", "0.7026451476472091`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", "\[Rule]", "0.32029220647073836`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.815386212264332*^9, 3.815386306516597*^9}},
 CellLabel->
  "Out[167]=",ExpressionUUID->"c3269006-4fb2-4435-a3e6-883665db4f7f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       SuperscriptBox["a0", "2"], 
       RowBox[{
        RowBox[{"-", "2"}], " ", "jMax"}]]}], "+", "v0", "+", 
     RowBox[{"a0", " ", "t"}]}], "\[Equal]", "vMax"}], ",", "t"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.815386483419574*^9, 3.815386599085203*^9}, {
   3.8153869341443157`*^9, 3.815387057583847*^9}, {3.815387110936233*^9, 
   3.8153871111355352`*^9}, 3.815387215488923*^9, {3.815387246273223*^9, 
   3.815387246376728*^9}, {3.8153873818509274`*^9, 3.815387386722125*^9}},
 CellLabel->
  "In[194]:=",ExpressionUUID->"210a25f2-9b17-4e4b-bc3f-6f2e7a55ac8f"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", 
       SuperscriptBox["a0", "2"]}], "-", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
      RowBox[{"2", " ", "jMax", " ", "vMax"}]}], 
     RowBox[{"2", " ", "a0", " ", "jMax"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.815386498393416*^9, 3.815386599452407*^9}, {
   3.815386946414404*^9, 3.8153869945351954`*^9}, {3.815387026438641*^9, 
   3.8153870579233007`*^9}, 3.815387112293728*^9, 3.8153872160448503`*^9, 
   3.815387246688963*^9, {3.8153873822076607`*^9, 3.8153873870569553`*^9}},
 CellLabel->
  "Out[194]=",ExpressionUUID->"e39c0b7c-dbb9-40cb-82ec-435732f72361"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"v1", "\[Equal]", 
      RowBox[{"v0", "-", 
       RowBox[{"aMax", "*", "t1"}]}]}], ",", 
     RowBox[{
      RowBox[{"-", "vMax"}], "\[Equal]", 
      RowBox[{"v1", "-", 
       RowBox[{"aMax", "*", "t2"}], "+", 
       RowBox[{
        FractionBox["1", "2"], "jMax", " ", 
        SuperscriptBox["t2", "2"]}]}]}], ",", 
     RowBox[{"0", "\[Equal]", 
      RowBox[{
       RowBox[{"-", "aMax"}], "+", 
       RowBox[{"jMax", " ", "t2"}]}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t1", ",", "t2", ",", "v1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.8175410738410997`*^9, 3.8175411736750193`*^9}, {
  3.817541259584454*^9, 3.8175413001474237`*^9}, {3.817541356210436*^9, 
  3.8175413573686523`*^9}},
 CellLabel->"In[2]:=",ExpressionUUID->"2b4f4afd-c126-482c-a3f6-b488e5a0565c"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t1", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["aMax", "2"]}], "+", 
       RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
       RowBox[{"2", " ", "jMax", " ", "vMax"}]}], 
      RowBox[{"2", " ", "aMax", " ", "jMax"}]]}], ",", 
    RowBox[{"t2", "\[Rule]", 
     FractionBox["aMax", "jMax"]}], ",", 
    RowBox[{"v1", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "vMax"}]}], 
      RowBox[{"2", " ", "jMax"}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.817541166642359*^9, 3.817541174125177*^9}, 
   3.81754126032939*^9, 3.817541300882049*^9, {3.817541338945429*^9, 
   3.817541357725025*^9}},
 CellLabel->"Out[2]=",ExpressionUUID->"e8c41703-c7c0-4861-af08-97504d931e3c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"a1", "\[Equal]", 
       RowBox[{"-", "aMax"}]}], ",", 
      RowBox[{"v1", "\[Equal]", 
       RowBox[{"v0", "-", 
        RowBox[{"aMax", "*", "t1"}]}]}], ",", 
      RowBox[{
       RowBox[{"-", "vMax"}], "\[Equal]", 
       RowBox[{"v1", "+", 
        RowBox[{"a1", "*", "t2"}], "+", 
        RowBox[{
         RowBox[{"jMax", "/", "2"}], "*", 
         RowBox[{"t2", "^", "2"}]}]}]}], ",", 
      RowBox[{"0", "\[Equal]", 
       RowBox[{"a1", "+", 
        RowBox[{"jMax", " ", "t2"}]}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"t1", ",", "t2", ",", "a1", ",", "v1"}], "}"}]}], "]"}], 
  "\n"}]], "Input",
 CellChangeTimes->{{3.8175415349452047`*^9, 3.817541541413602*^9}},
 CellLabel->"In[3]:=",ExpressionUUID->"aeb71e0a-7391-4acf-aa84-dda309dee7aa"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t1", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["aMax", "2"]}], "+", 
       RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
       RowBox[{"2", " ", "jMax", " ", "vMax"}]}], 
      RowBox[{"2", " ", "aMax", " ", "jMax"}]]}], ",", 
    RowBox[{"t2", "\[Rule]", 
     FractionBox["aMax", "jMax"]}], ",", 
    RowBox[{"a1", "\[Rule]", 
     RowBox[{"-", "aMax"}]}], ",", 
    RowBox[{"v1", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "vMax"}]}], 
      RowBox[{"2", " ", "jMax"}]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.817541541864256*^9},
 CellLabel->"Out[3]=",ExpressionUUID->"e2efd1a3-7c8f-453f-b25a-28d75b5ddd9e"]
}, Open  ]]
},
WindowSize->{931, 747},
WindowMargins->{{-53, Automatic}, {Automatic, 68}},
FrontEndVersion->"12.1 for Mac OS X x86 (64-bit) (June 19, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"706c30b1-c7eb-4050-b3e2-34c6f60d06c7"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 343, 5, 35, "Text",ExpressionUUID->"6747c71c-c66c-433d-9613-bddcf8a50059"],
Cell[904, 27, 416, 8, 35, "Text",ExpressionUUID->"9c0ba946-2fb4-4a4b-a305-4d0102c9636e"],
Cell[1323, 37, 3787, 118, 449, "Input",ExpressionUUID->"01d94644-43f4-4ebf-b9dd-650c0bcc93aa"],
Cell[5113, 157, 875, 20, 30, "Input",ExpressionUUID->"ccac5833-2cc2-4703-8af2-4673d2c0a437"],
Cell[5991, 179, 158, 3, 35, "Text",ExpressionUUID->"f1f1d133-d9ee-48d8-ab08-fdb8b843aed9"],
Cell[6152, 184, 648, 18, 69, "Input",ExpressionUUID->"e9b3b786-2ee6-4ad4-90fe-0843f9a56019"],
Cell[CellGroupData[{
Cell[6825, 206, 443, 10, 30, "Input",ExpressionUUID->"635600fe-01e0-4d25-8184-067440ee5de9"],
Cell[7271, 218, 976, 30, 58, "Output",ExpressionUUID->"778a3e8d-bcc9-4cbe-a256-9baed7c1507e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8284, 253, 400, 11, 30, "Input",ExpressionUUID->"75407e54-a918-40b0-94a0-d82634d676e5"],
Cell[8687, 266, 397, 11, 56, "Output",ExpressionUUID->"a84f9442-a454-4874-ae35-b8c5c8fbc207"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9121, 282, 698, 17, 53, "Input",ExpressionUUID->"8efb60ef-a462-475b-8ff5-e51b2c982b76"],
Cell[9822, 301, 1127, 34, 57, "Output",ExpressionUUID->"f3046318-00c5-4e1d-967a-6f60d1eb4324"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10986, 340, 731, 21, 47, "Input",ExpressionUUID->"38121ff9-6236-4cfd-98df-aef065814608"],
Cell[11720, 363, 393, 11, 34, "Output",ExpressionUUID->"c3269006-4fb2-4435-a3e6-883665db4f7f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12150, 379, 685, 17, 53, "Input",ExpressionUUID->"210a25f2-9b17-4e4b-bc3f-6f2e7a55ac8f"],
Cell[12838, 398, 713, 16, 56, "Output",ExpressionUUID->"e39c0b7c-dbb9-40cb-82ec-435732f72361"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13588, 419, 891, 24, 47, "Input",ExpressionUUID->"2b4f4afd-c126-482c-a3f6-b488e5a0565c"],
Cell[14482, 445, 877, 23, 56, "Output",ExpressionUUID->"e8c41703-c7c0-4861-af08-97504d931e3c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15396, 473, 873, 25, 52, "Input",ExpressionUUID->"aeb71e0a-7391-4acf-aa84-dda309dee7aa"],
Cell[16272, 500, 822, 23, 104, "Output",ExpressionUUID->"e2efd1a3-7c8f-453f-b25a-28d75b5ddd9e"]
}, Open  ]]
}
]
*)

