/*
      ____  ____
     /   /\/   /
    /___/  \  /   Copyright (c) 2021, Xilinx®.
    \   \   \/    Author: Víctor Mayoral Vilches <victorma@xilinx.com>
     \   \
     /   /        Licensed under the Apache License, Version 2.0 (the "License");
    /___/   /\    you may not use this file except in compliance with the License.
    \   \  /  \   You may obtain a copy of the License at
     \___\/\___\            http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
*/

#ifndef XILINX_VITIS_COMMON_INCLUDE_COMMON_ROS_OPENCL_120_HPP_
#define XILINX_VITIS_COMMON_INCLUDE_COMMON_ROS_OPENCL_120_HPP_

#define CL_HPP_CL_1_2_DEFAULT_BUILD
#define CL_HPP_TARGET_OPENCL_VERSION 120
#define CL_HPP_MINIMUM_OPENCL_VERSION 120
#define CL_HPP_ENABLE_PROGRAM_CONSTRUCTION_FROM_ARRAY_COMPATIBILITY 1
#define CL_USE_DEPRECATED_OPENCL_1_2_APIS

// OCL_CHECK doesn't work if call has templatized function call
#define OCL_CHECK(error, call)  \
    call;  \
    if (error != CL_SUCCESS) {  \
        fprintf(stderr,  \
            "%s:%d Error calling " #call ", error code is: %d\n",  \
            __FILE__, __LINE__, error);  \
        exit(EXIT_FAILURE);  \
    }

#include <unistd.h>
#include <iostream>
#include <fstream>
#include <CL/cl2.hpp>

#endif  // XILINX_VITIS_COMMON_INCLUDE_COMMON_ROS_OPENCL_120_HPP_
