// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
/******

Implementation of functions for InfectableReaderListener

*********/

#include "CompoundReaderListener.h"

namespace eprosima{
namespace fastrtps{
namespace rtps{


void CompoundReaderListener::attachListener(ReaderListener *secondary_listener){
	attached_listener_mutex.lock();
	attached_listener = secondary_listener;
	attached_listener_mutex.unlock();

}

void CompoundReaderListener::detachListener(){
	attached_listener_mutex.lock();
	attached_listener = nullptr;
	attached_listener_mutex.unlock();
}

bool CompoundReaderListener::hasReaderAttached(){
	if(attached_listener != nullptr)
		return true;
	return false;
}
ReaderListener* CompoundReaderListener::getAttachedListener(){
	if(attached_listener != nullptr)
		return attached_listener;
	return nullptr;
}	

//Namespace ends
}}}
