#! /usr/bin/env python
# make_token_names.py
#
# Scans src/token_enum.h and creates src/token_names.h
#

import os

infile = "../src/token_enum.h"
outfile = "../src/token_names.h"

basepath = os.path.dirname(__file__)

prefix = """/*
 * Generated by `%s`
 */
#ifndef TOKEN_NAMES_H_INCLUDED
#define TOKEN_NAMES_H_INCLUDED

const char *token_names[] =
{
""" % os.path.basename(__file__)

suffix = """};

#endif /* TOKEN_NAMES_H_INCLUDED */
"""

with open(os.path.join(basepath, infile), 'r') as h:
    lines = h.read().splitlines()

# Print lines from infile that contain CT_, stripping everything after ','
# and formating the result as a quoted C string.
enums = []
for line in lines:
    line = line.lstrip()
    if not line.startswith('CT_'):
        continue
    enum = line[3:].split(',', 1)[0]
    enums.append(enum)

with open(os.path.join(basepath, outfile), 'w') as h:
    h.write(prefix)
    for enum in enums:
        h.write('   "%s",\n' % enum)
    h.write(suffix)
