// Copyright (c) 2020 by Robert Bosch GmbH. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
#ifndef IOX_UTILS_WIN_PLATFORM_PWD_HPP
#define IOX_UTILS_WIN_PLATFORM_PWD_HPP

#include "iceoryx_utils/platform/types.hpp"

struct passwd
{
    char* pw_name;
    char* pw_passwd;
    uid_t pw_uid;
    gid_t pw_gid;
    char* pw_gecos;
    char* pw_dir;
    char* pw_shell;
};


inline struct passwd* getpwnam(const char* name)
{
    return nullptr;
}

inline struct passwd* getpwuid(uid_t uid)
{
    return nullptr;
}

inline uid_t geteuid()
{
    return 0;
}

#endif // IOX_UTILS_WIN_PLATFORM_PWD_HPP
