/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.fastrtps;

import com.eprosima.fastcdr.idl.generator.TypesGenerator;
import com.eprosima.fastrtps.ProcessOutput;
import com.eprosima.fastrtps.exceptions.BadArgumentException;
import com.eprosima.fastrtps.idl.grammar.Context;
import com.eprosima.fastrtps.solution.Project;
import com.eprosima.fastrtps.solution.Solution;
import com.eprosima.fastrtps.util.Utils;
import com.eprosima.fastrtps.util.VSConfiguration;
import com.eprosima.idl.generator.manager.TemplateExtension;
import com.eprosima.idl.generator.manager.TemplateGroup;
import com.eprosima.idl.generator.manager.TemplateManager;
import com.eprosima.idl.parser.grammar.IDLLexer;
import com.eprosima.idl.parser.grammar.IDLParser;
import com.eprosima.idl.parser.tree.AnnotationDeclaration;
import com.eprosima.idl.parser.tree.AnnotationMember;
import com.eprosima.idl.parser.tree.Specification;
import com.eprosima.idl.parser.typecode.PrimitiveTypeCode;
import com.eprosima.idl.parser.typecode.TypeCode;
import com.eprosima.idl.util.Util;
import com.eprosima.log.ColorMessage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Vector;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.DefaultTemplateLexer;
import org.antlr.v4.runtime.ANTLRFileStream;
import org.antlr.v4.runtime.CommonTokenStream;

public class fastrtpsgen {
    private static ArrayList<String> m_platforms = null;
    private Vector<String> m_idlFiles;
    protected static String m_appEnv = "FASTRTPSHOME";
    private String m_exampleOption = null;
    private boolean m_ppDisable = false;
    private boolean m_replace = false;
    private String m_ppPath = null;
    private final String m_defaultOutputDir;
    private String m_outputDir = this.m_defaultOutputDir = "." + File.separator;
    private String m_tempDir = null;
    protected static String m_appName = "fastrtpsgen";
    private boolean m_publishercode = true;
    private boolean m_subscribercode = true;
    private boolean m_atLeastOneStructure = false;
    protected static String m_localAppProduct = "fastrtps";
    private ArrayList m_includePaths = new ArrayList();
    private String m_command = null;
    private String m_extra_command = null;
    private ArrayList m_lineCommand = null;
    private ArrayList m_lineCommandForWorkDirSet = null;
    private String m_spTemplate = "main";
    private static VSConfiguration[] m_vsconfigurations = new VSConfiguration[]{new VSConfiguration("Debug DLL", "Win32", true, true), new VSConfiguration("Release DLL", "Win32", false, true), new VSConfiguration("Debug", "Win32", true, false), new VSConfiguration("Release", "Win32", false, false)};
    private String m_os = null;
    private boolean m_local = false;
    private boolean fusion_ = false;
    private String m_package = "";
    private boolean m_type_object_files = false;
    private LANGUAGE m_languageOption = LANGUAGE.CPP;

    public fastrtpsgen(String[] args) throws BadArgumentException {
        int count = 0;
        this.m_os = System.getProperty("os.name");
        this.m_idlFiles = new Vector();
        while (count < args.length) {
            String arg;
            if (!(arg = args[count++]).startsWith("-")) {
                this.m_idlFiles.add(arg);
                continue;
            }
            if (arg.equals("-example")) {
                if (count < args.length) {
                    this.m_exampleOption = args[count++];
                    if (m_platforms.contains(this.m_exampleOption)) continue;
                    throw new BadArgumentException("Unknown example arch " + this.m_exampleOption);
                }
                throw new BadArgumentException("No architecture speficied after -example argument");
            }
            if (arg.equals("-language")) {
                if (count < args.length) {
                    String languageOption;
                    if ((languageOption = args[count++]).equalsIgnoreCase("c++")) {
                        this.m_languageOption = LANGUAGE.CPP;
                        continue;
                    }
                    if (languageOption.equalsIgnoreCase("java")) {
                        this.m_languageOption = LANGUAGE.JAVA;
                        continue;
                    }
                    throw new BadArgumentException("Unknown language " + languageOption);
                }
                throw new BadArgumentException("No language specified after -language argument");
            }
            if (arg.equals("-package")) {
                if (count < args.length) {
                    this.m_package = args[count++];
                    continue;
                }
                throw new BadArgumentException("No package after -package argument");
            }
            if (arg.equals("-ppPath")) {
                if (count < args.length) {
                    this.m_ppPath = args[count++];
                    continue;
                }
                throw new BadArgumentException("No URL specified after -ppPath argument");
            }
            if (arg.equals("-ppDisable")) {
                this.m_ppDisable = true;
                continue;
            }
            if (arg.equals("-replace")) {
                this.m_replace = true;
                continue;
            }
            if (arg.equals("-d")) {
                if (count < args.length) {
                    this.m_outputDir = Utils.addFileSeparator(args[count++]);
                    continue;
                }
                throw new BadArgumentException("No URL specified after -d argument");
            }
            if (arg.equals("-t")) {
                if (count < args.length) {
                    this.m_tempDir = Utils.addFileSeparator(args[count++]);
                    continue;
                }
                throw new BadArgumentException("No temporary directory specified after -t argument");
            }
            if (arg.equals("-version")) {
                this.showVersion();
                System.exit(0);
                continue;
            }
            if (arg.equals("-help")) {
                fastrtpsgen.printHelp();
                System.exit(0);
                continue;
            }
            if (arg.equals("-local")) {
                this.m_local = true;
                continue;
            }
            if (arg.equals("-fusion")) {
                this.fusion_ = true;
                continue;
            }
            if (arg.equals("-typeobject")) {
                this.m_type_object_files = true;
                continue;
            }
            if (arg.equals("-I")) {
                if (count < args.length) {
                    this.m_includePaths.add("-I".concat(args[count++]));
                    continue;
                }
                throw new BadArgumentException("No include directory specified after -I argument");
            }
            throw new BadArgumentException("Unknown argument " + arg);
        }
        if (this.m_idlFiles.isEmpty()) {
            throw new BadArgumentException("No input files given");
        }
    }

    public boolean execute() {
        File dir;
        if (!this.m_outputDir.equals(this.m_defaultOutputDir) && !(dir = new File(this.m_outputDir)).exists()) {
            System.out.println(ColorMessage.error() + "The specified output directory does not exist");
            return false;
        }
        boolean returnedValue = this.globalInit();
        if (returnedValue) {
            Solution solution = new Solution(this.m_languageOption, this.m_exampleOption, this.getVersion(), this.m_publishercode, this.m_subscribercode);
            System.out.println("Loading templates...");
            TemplateManager.setGroupLoaderDirectories("com/eprosima/fastrtps/idl/templates:com/eprosima/fastcdr/idl/templates");
            if (this.m_os.contains("Windows")) {
                solution.addInclude("$(" + m_appEnv + ")/include");
                solution.addLibraryPath("$(" + m_appEnv + ")/lib");
                if (this.m_exampleOption != null) {
                    solution.addLibraryPath("$(" + m_appEnv + ")/lib/" + this.m_exampleOption);
                }
            }
            if (this.m_languageOption == LANGUAGE.JAVA) {
                solution.addInclude("$(JAVA_HOME)/include");
                if (this.m_exampleOption != null && this.m_exampleOption.contains("Linux")) {
                    solution.addInclude("$(JAVA_HOME)/include/linux");
                }
            }
            if (this.m_exampleOption != null && !this.m_exampleOption.contains("Win")) {
                solution.addLibrary("fastcdr");
            }
            solution.addLibrary("fastrtps");
            for (int count = 0; returnedValue && count < this.m_idlFiles.size(); ++count) {
                Project project = this.process(this.m_idlFiles.get(count));
                if (project != null) {
                    solution.addProject(project);
                    continue;
                }
                returnedValue = false;
            }
            if (returnedValue && this.m_exampleOption != null && !(returnedValue = this.genSolution(solution))) {
                System.out.println(ColorMessage.error() + "While the solution was being generated");
            }
        }
        return returnedValue;
    }

    public static boolean loadPlatforms() {
        boolean returnedValue = false;
        m_platforms = new ArrayList();
        try {
            InputStream input = fastrtpsgen.class.getClassLoader().getResourceAsStream("platforms");
            InputStreamReader ir = new InputStreamReader(input);
            BufferedReader reader = new BufferedReader(ir);
            String line = null;
            while ((line = reader.readLine()) != null) {
                m_platforms.add(line);
            }
            returnedValue = true;
        }
        catch (Exception e) {
            System.out.println(ColorMessage.error() + "Getting platforms. " + e.getMessage());
        }
        return returnedValue;
    }

    private String getVersion() {
        try {
            InputStream input = this.getClass().getClassLoader().getResourceAsStream("version");
            byte[] b = new byte[input.available()];
            input.read(b);
            String text = new String(b);
            int beginindex = text.indexOf("=");
            return text.substring(beginindex + 1);
        }
        catch (Exception ex) {
            System.out.println(ColorMessage.error() + "Getting version. " + ex.getMessage());
            return "";
        }
    }

    private void showVersion() {
        String version = this.getVersion();
        System.out.println(m_appName + " version " + version);
    }

    public static void printHelp() {
        System.out.println(m_appName + " usage:");
        System.out.println("\t" + m_appName + " [options] <file> [<file> ...]");
        System.out.println("\twhere the options are:");
        System.out.println("\t\t-help: shows this help");
        System.out.println("\t\t-version: shows the current version of eProsima Fast RTPS.");
        System.out.println("\t\t-example <platform>: Generates a solution for a specific platform (example: x64Win64VS2015)");
        System.out.println("\t\t\tSupported platforms:");
        for (int count = 0; count < m_platforms.size(); ++count) {
            System.out.println("\t\t\t * " + m_platforms.get(count));
        }
        System.out.println("\t\t-replace: replaces existing generated files.");
        System.out.println("\t\t-ppDisable: disables the preprocessor.");
        System.out.println("\t\t-ppPath: specifies the preprocessor path.");
        System.out.println("\t\t-I <path>: add directory to preprocessor include paths.");
        System.out.println("\t\t-d <path>: sets an output directory for generated files.");
        System.out.println("\t\t-t <temp dir>: sets a specific directory as a temporary directory.");
        System.out.println("\tand the supported input files are:");
        System.out.println("\t* IDL files.");
    }

    public boolean globalInit() {
        Object dds_root = null;
        Object tao_root = null;
        Object fastrtps_root = null;
        if (this.m_tempDir == null) {
            if (this.m_os.contains("Windows")) {
                String tempPath = System.getenv("TEMP");
                if (tempPath == null) {
                    tempPath = System.getenv("TMP");
                }
                this.m_tempDir = tempPath;
            } else if (this.m_os.contains("Linux") || this.m_os.contains("Mac")) {
                this.m_tempDir = "/tmp/";
            }
        }
        if (this.m_tempDir.charAt(this.m_tempDir.length() - 1) != File.separatorChar) {
            this.m_tempDir = this.m_tempDir + File.separator;
        }
        this.m_lineCommand = new ArrayList();
        return true;
    }

    private Project process(String idlFilename) {
        Project project;
        block2: {
            project = null;
            System.out.println("Processing the file " + idlFilename + "...");
            try {
                project = this.parseIDL(idlFilename);
            }
            catch (Exception ioe) {
                System.out.println(ColorMessage.error() + "Cannot generate the files");
                if (ioe.getMessage().equals("")) break block2;
                System.out.println(ioe.getMessage());
            }
        }
        return project;
    }

    private Project parseIDL(String idlFilename) {
        boolean returnedValue = false;
        String idlParseFileName = idlFilename;
        Project project = null;
        String onlyFileName = Util.getIDLFileNameOnly(idlFilename);
        if (!this.m_ppDisable) {
            idlParseFileName = this.callPreprocessor(idlFilename);
        }
        if (idlParseFileName != null) {
            Context ctx = new Context(onlyFileName, idlFilename, this.m_includePaths, this.m_subscribercode, this.m_publishercode, m_localAppProduct, this.m_type_object_files);
            if (this.fusion_) {
                ctx.setActivateFusion(true);
            }
            AnnotationDeclaration keyann = ctx.createAnnotationDeclaration("Key", null);
            keyann.addMember(new AnnotationMember("value", new PrimitiveTypeCode(7), "true"));
            AnnotationDeclaration topicann = ctx.createAnnotationDeclaration("Topic", null);
            topicann.addMember(new AnnotationMember("value", new PrimitiveTypeCode(7), "true"));
            TemplateManager tmanager = new TemplateManager("FastCdrCommon:eprosima:Common");
            ArrayList<TemplateExtension> extensions = new ArrayList<TemplateExtension>();
            extensions.add(new TemplateExtension("struct_type", "keyFunctionHeadersStruct"));
            extensions.add(new TemplateExtension("union_type", "keyFunctionHeadersUnion"));
            tmanager.addGroup("TypesHeader", extensions);
            if (this.m_type_object_files) {
                tmanager.addGroup("TypeObjectHeader", extensions);
            }
            extensions.clear();
            extensions.add(new TemplateExtension("struct_type", "keyFunctionSourcesStruct"));
            tmanager.addGroup("TypesSource", extensions);
            if (this.m_type_object_files) {
                tmanager.addGroup("TypeObjectSource", extensions);
            }
            tmanager.addGroup("RTPSPubSubTypeHeader");
            tmanager.addGroup("RTPSPubSubTypeSource");
            tmanager.addGroup("RTPSPublisherHeader");
            tmanager.addGroup("RTPSPublisherSource");
            tmanager.addGroup("RTPSSubscriberHeader");
            tmanager.addGroup("RTPSSubscriberSource");
            tmanager.addGroup("RTPSPubSubMain");
            if (this.m_languageOption == LANGUAGE.JAVA) {
                tmanager.addGroup("JNIHeader");
                tmanager.addGroup("JNISource");
                tmanager.addGroup("JavaSource");
                ctx.setPackage(this.m_package);
            }
            TemplateGroup maintemplates = tmanager.createTemplateGroup("main");
            maintemplates.setAttribute("ctx", ctx);
            try {
                ANTLRFileStream input = new ANTLRFileStream(idlParseFileName);
                IDLLexer lexer = new IDLLexer(input);
                lexer.setContext(ctx);
                CommonTokenStream tokens = new CommonTokenStream(lexer);
                IDLParser parser = new IDLParser(tokens);
                Specification specification = parser.specification((com.eprosima.idl.context.Context)ctx, (TemplateManager)tmanager, (TemplateGroup)maintemplates).spec;
                returnedValue = specification != null;
            }
            catch (FileNotFoundException ex) {
                System.out.println(ColorMessage.error("FileNotFounException") + "The File " + idlParseFileName + " was not found.");
            }
            catch (Exception ex) {
                System.out.println(ColorMessage.error("Exception") + ex.getMessage());
            }
            if (returnedValue) {
                project = new Project(onlyFileName, idlFilename, (LinkedHashSet)ctx.getDependencies());
                System.out.println("Generating Type definition files...");
                returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + ".h", maintemplates.getTemplate("TypesHeader"), this.m_replace);
                if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + ".cxx", maintemplates.getTemplate("TypesSource"), this.m_replace))) {
                    project.addCommonIncludeFile(onlyFileName + ".h");
                    project.addCommonSrcFile(onlyFileName + ".cxx");
                    if (this.m_type_object_files) {
                        System.out.println("Generating TypeObject files...");
                        returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "TypeObject.h", maintemplates.getTemplate("TypeObjectHeader"), this.m_replace);
                        if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "TypeObject.cxx", maintemplates.getTemplate("TypeObjectSource"), this.m_replace))) {
                            project.addCommonIncludeFile(onlyFileName + "TypeObject.h");
                            project.addCommonSrcFile(onlyFileName + "TypeObject.cxx");
                        }
                    }
                }
                if (ctx.existsLastStructure()) {
                    this.m_atLeastOneStructure = true;
                    project.setHasStruct(true);
                    System.out.println("Generating TopicDataTypes files...");
                    returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "PubSubTypes.h", maintemplates.getTemplate("RTPSPubSubTypeHeader"), this.m_replace);
                    if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "PubSubTypes.cxx", maintemplates.getTemplate("RTPSPubSubTypeSource"), this.m_replace))) {
                        project.addProjectIncludeFile(onlyFileName + "PubSubTypes.h");
                        project.addProjectSrcFile(onlyFileName + "PubSubTypes.cxx");
                    }
                    if (this.m_exampleOption != null) {
                        System.out.println("Generating Publisher files...");
                        returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "Publisher.h", maintemplates.getTemplate("RTPSPublisherHeader"), this.m_replace);
                        if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "Publisher.cxx", maintemplates.getTemplate("RTPSPublisherSource"), this.m_replace))) {
                            project.addProjectIncludeFile(onlyFileName + "Publisher.h");
                            project.addProjectSrcFile(onlyFileName + "Publisher.cxx");
                        }
                        System.out.println("Generating Subscriber files...");
                        returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "Subscriber.h", maintemplates.getTemplate("RTPSSubscriberHeader"), this.m_replace);
                        if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "Subscriber.cxx", maintemplates.getTemplate("RTPSSubscriberSource"), this.m_replace))) {
                            project.addProjectIncludeFile(onlyFileName + "Subscriber.h");
                            project.addProjectSrcFile(onlyFileName + "Subscriber.cxx");
                        }
                        System.out.println("Generating main file...");
                        returnedValue = Utils.writeFile(this.m_outputDir + onlyFileName + "PubSubMain.cxx", maintemplates.getTemplate("RTPSPubSubMain"), this.m_replace);
                        if (returnedValue) {
                            project.addProjectSrcFile(onlyFileName + "PubSubMain.cxx");
                        }
                    }
                }
            }
            if (returnedValue && this.m_languageOption == LANGUAGE.JAVA) {
                File dirs;
                String outputDir = this.m_outputDir;
                if (!(this.m_package.isEmpty() || (dirs = new File(outputDir = this.m_outputDir + File.separator + this.m_package.replace('.', File.separatorChar))).exists() || dirs.mkdirs())) {
                    System.out.println(ColorMessage.error() + "Cannot create directories for Java packages.");
                    return null;
                }
                TypesGenerator typeGen = new TypesGenerator(tmanager, this.m_outputDir, this.m_replace);
                TypeCode.javapackage = this.m_package + (this.m_package.isEmpty() ? "" : ".");
                if (!typeGen.generate(ctx, outputDir + File.separator, this.m_package, onlyFileName, null)) {
                    System.out.println(ColorMessage.error() + "generating Java types");
                    return null;
                }
                if (ctx.existsLastStructure()) {
                    System.out.println("Generando fichero " + this.m_outputDir + onlyFileName + "PubSub.java");
                    if (!Utils.writeFile(outputDir + File.separator + onlyFileName + "PubSub.java", maintemplates.getTemplate("JavaSource"), this.m_replace)) {
                        return null;
                    }
                    if (!this.callJavah(idlFilename)) {
                        return null;
                    }
                }
                if (!Utils.writeFile(this.m_outputDir + onlyFileName + "PubSubJNII.h", maintemplates.getTemplate("JNIHeader"), this.m_replace)) {
                    return null;
                }
                project.addJniIncludeFile(onlyFileName + "PubSubJNII.h");
                StringTemplate jnisourceTemplate = maintemplates.getTemplate("JNISource");
                if (Utils.writeFile(this.m_outputDir + onlyFileName + "PubSubJNI.cxx", jnisourceTemplate, this.m_replace)) {
                    project.addJniSrcFile(onlyFileName + "PubSubJNI.cxx");
                } else {
                    return null;
                }
            }
        }
        return returnedValue ? project : null;
    }

    private boolean genSolution(Solution solution) {
        String METHOD_NAME = "genSolution";
        boolean returnedValue = true;
        if (this.m_atLeastOneStructure) {
            if (this.m_exampleOption != null) {
                System.out.println("Generating solution for arch " + this.m_exampleOption + "...");
                if (this.m_exampleOption.equals("CMake")) {
                    System.out.println("Generating CMakeLists solution");
                    returnedValue = this.genCMakeLists(solution);
                } else if (this.m_exampleOption.substring(3, 6).equals("Win")) {
                    System.out.println("Generating Windows solution");
                    if (this.m_exampleOption.startsWith("i86")) {
                        returnedValue = this.m_exampleOption.charAt(this.m_exampleOption.length() - 1) == '3' ? this.genVS(solution, null, "12") : this.genVS(solution, null, "14");
                    } else if (this.m_exampleOption.startsWith("x64")) {
                        for (int index = 0; index < m_vsconfigurations.length; ++index) {
                            m_vsconfigurations[index].setPlatform("x64");
                        }
                        returnedValue = this.m_exampleOption.charAt(this.m_exampleOption.length() - 1) == '3' ? this.genVS(solution, "x64", "12") : this.genVS(solution, "x64", "14");
                    } else {
                        returnedValue = false;
                    }
                } else if (this.m_exampleOption.substring(3, 8).equals("Linux")) {
                    System.out.println("Generating makefile solution");
                    returnedValue = this.m_exampleOption.startsWith("i86") ? this.genMakefile(solution, "-m32") : (this.m_exampleOption.startsWith("x64") ? this.genMakefile(solution, "-m64") : (this.m_exampleOption.startsWith("arm") ? this.genMakefile(solution, "") : false));
                }
            }
        } else {
            System.out.println(ColorMessage.warning() + "No structure found in any of the provided IDL; no example files have been generated");
        }
        return returnedValue;
    }

    private boolean genVS(Solution solution, String arch, String vsVersion) {
        String METHOD_NAME = "genVS";
        boolean returnedValue = false;
        StringTemplateGroup vsTemplates = StringTemplateGroup.loadGroup("VS", DefaultTemplateLexer.class, null);
        if (vsTemplates != null) {
            StringTemplate tsolution = vsTemplates.getInstanceOf("solution");
            StringTemplate tproject = vsTemplates.getInstanceOf("project");
            StringTemplate tprojectFiles = vsTemplates.getInstanceOf("projectFiles");
            StringTemplate tprojectPubSub = vsTemplates.getInstanceOf("projectPubSub");
            StringTemplate tprojectFilesPubSub = vsTemplates.getInstanceOf("projectFilesPubSub");
            StringTemplate tprojectJNI = null;
            StringTemplate tprojectFilesJNI = null;
            if (this.m_languageOption == LANGUAGE.JAVA) {
                tprojectJNI = vsTemplates.getInstanceOf("projectJNI");
                tprojectFilesJNI = vsTemplates.getInstanceOf("projectFilesJNI");
            }
            returnedValue = true;
            for (int count = 0; returnedValue && count < solution.getProjects().size(); ++count) {
                Project project = (Project)solution.getProjects().get(count);
                tproject.setAttribute("solution", solution);
                tproject.setAttribute("project", project);
                tproject.setAttribute("example", this.m_exampleOption);
                tproject.setAttribute("vsVersion", vsVersion);
                tprojectFiles.setAttribute("project", project);
                tprojectFiles.setAttribute("vsVersion", vsVersion);
                tprojectPubSub.setAttribute("solution", solution);
                tprojectPubSub.setAttribute("project", project);
                tprojectPubSub.setAttribute("example", this.m_exampleOption);
                tprojectPubSub.setAttribute("vsVersion", vsVersion);
                tprojectFilesPubSub.setAttribute("project", project);
                tprojectFilesPubSub.setAttribute("vsVersion", vsVersion);
                if (this.m_languageOption == LANGUAGE.JAVA) {
                    tprojectJNI.setAttribute("solution", solution);
                    tprojectJNI.setAttribute("project", project);
                    tprojectJNI.setAttribute("example", this.m_exampleOption);
                    tprojectJNI.setAttribute("vsVersion", vsVersion);
                    tprojectFilesJNI.setAttribute("project", project);
                }
                for (int index = 0; index < m_vsconfigurations.length; ++index) {
                    tproject.setAttribute("configurations", m_vsconfigurations[index]);
                    tprojectPubSub.setAttribute("configurations", m_vsconfigurations[index]);
                    if (this.m_languageOption != LANGUAGE.JAVA) continue;
                    tprojectJNI.setAttribute("configurations", m_vsconfigurations[index]);
                }
                returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "Types-" + this.m_exampleOption + ".vcxproj", tproject, this.m_replace);
                if (returnedValue && (returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "Types-" + this.m_exampleOption + ".vcxproj.filters", tprojectFiles, this.m_replace)) && project.getHasStruct() && (returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "PublisherSubscriber-" + this.m_exampleOption + ".vcxproj", tprojectPubSub, this.m_replace))) {
                    returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "PublisherSubscriber-" + this.m_exampleOption + ".vcxproj.filters", tprojectFilesPubSub, this.m_replace);
                }
                if (returnedValue && this.m_languageOption == LANGUAGE.JAVA && (returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "PubSubJNI-" + this.m_exampleOption + ".vcxproj", tprojectJNI, this.m_replace))) {
                    returnedValue = Utils.writeFile(this.m_outputDir + project.getName() + "PubSubJNI-" + this.m_exampleOption + ".vcxproj.filters", tprojectFilesJNI, this.m_replace);
                }
                tproject.reset();
                tprojectFiles.reset();
                tprojectPubSub.reset();
                tprojectFilesPubSub.reset();
                if (this.m_languageOption != LANGUAGE.JAVA) continue;
                tprojectJNI.reset();
                tprojectFilesJNI.reset();
            }
            if (returnedValue) {
                tsolution.setAttribute("solution", solution);
                tsolution.setAttribute("example", this.m_exampleOption);
                for (int index = 0; index < m_vsconfigurations.length; ++index) {
                    tsolution.setAttribute("configurations", m_vsconfigurations[index]);
                }
                if (this.m_languageOption == LANGUAGE.JAVA) {
                    tsolution.setAttribute("generateJava", true);
                }
                String vsVersion_sol = "2013";
                if (vsVersion.equals("14")) {
                    vsVersion_sol = "2015";
                }
                tsolution.setAttribute("vsVersion", vsVersion_sol);
                returnedValue = Utils.writeFile(this.m_outputDir + "solution-" + this.m_exampleOption + ".sln", tsolution, this.m_replace);
            }
        } else {
            System.out.println("ERROR<genVS>: Cannot load the template group VS2013");
        }
        return returnedValue;
    }

    private boolean genMakefile(Solution solution, String arch) {
        boolean returnedValue = false;
        StringTemplate makecxx = null;
        StringTemplateGroup makeTemplates = StringTemplateGroup.loadGroup("makefile", DefaultTemplateLexer.class, null);
        if (makeTemplates != null) {
            makecxx = makeTemplates.getInstanceOf("makecxx");
            makecxx.setAttribute("solution", solution);
            makecxx.setAttribute("example", this.m_exampleOption);
            makecxx.setAttribute("arch", arch);
            returnedValue = Utils.writeFile(this.m_outputDir + "makefile_" + this.m_exampleOption, makecxx, this.m_replace);
        }
        return returnedValue;
    }

    private boolean genCMakeLists(Solution solution) {
        boolean returnedValue = false;
        StringTemplate cmake = null;
        StringTemplateGroup cmakeTemplates = StringTemplateGroup.loadGroup("CMakeLists", DefaultTemplateLexer.class, null);
        if (cmakeTemplates != null) {
            cmake = cmakeTemplates.getInstanceOf("cmakelists");
            cmake.setAttribute("solution", solution);
            returnedValue = Utils.writeFile(this.m_outputDir + "CMakeLists.txt", cmake, this.m_replace);
        }
        return returnedValue;
    }

    String callPreprocessor(String idlFilename) {
        String ppPath;
        String METHOD_NAME = "callPreprocessor";
        ArrayList<String> lineCommand = new ArrayList<String>();
        String[] lineCommandArray = null;
        String outputfile = Util.getIDLFileOnly(idlFilename) + ".cc";
        int exitVal = -1;
        FileOutputStream of = null;
        if (this.m_tempDir != null) {
            outputfile = this.m_tempDir + outputfile;
        }
        if (this.m_os.contains("Windows")) {
            try {
                of = new FileOutputStream(outputfile);
            }
            catch (FileNotFoundException ex) {
                System.out.println(ColorMessage.error("callPreprocessor") + "Cannot open file " + outputfile);
                return null;
            }
        }
        if ((ppPath = this.m_ppPath) == null) {
            if (this.m_os.contains("Windows")) {
                ppPath = "cl.exe";
            } else if (this.m_os.contains("Linux") || this.m_os.contains("Mac")) {
                ppPath = "cpp";
            }
        }
        lineCommand.add(ppPath);
        for (int i = 0; i < this.m_includePaths.size(); ++i) {
            if (this.m_os.contains("Windows")) {
                lineCommand.add(((String)this.m_includePaths.get(i)).replaceFirst("^-I", "/I"));
                continue;
            }
            if (!this.m_os.contains("Linux") && !this.m_os.contains("Mac")) continue;
            lineCommand.add((String)this.m_includePaths.get(i));
        }
        if (this.m_os.contains("Windows")) {
            lineCommand.add("/E");
            lineCommand.add("/C");
        }
        lineCommand.add(idlFilename);
        if (this.m_os.contains("Linux") || this.m_os.contains("Mac")) {
            lineCommand.add(outputfile);
        }
        lineCommandArray = new String[lineCommand.size()];
        lineCommandArray = lineCommand.toArray(lineCommandArray);
        try {
            Process preprocessor = Runtime.getRuntime().exec(lineCommandArray);
            ProcessOutput errorOutput = new ProcessOutput(preprocessor.getErrorStream(), "ERROR", false, null, true);
            ProcessOutput normalOutput = new ProcessOutput(preprocessor.getInputStream(), "OUTPUT", false, of, true);
            errorOutput.start();
            normalOutput.start();
            exitVal = preprocessor.waitFor();
            errorOutput.join();
            normalOutput.join();
        }
        catch (Exception e) {
            System.out.println(ColorMessage.error("callPreprocessor") + "Cannot execute the preprocessor. Reason: " + e.getMessage());
            return null;
        }
        if (of != null) {
            try {
                ((OutputStream)of).close();
            }
            catch (IOException e) {
                System.out.println(ColorMessage.error("callPreprocessor") + "Cannot close file " + outputfile);
            }
        }
        if (exitVal != 0) {
            System.out.println(ColorMessage.error("callPreprocessor") + "Preprocessor return an error " + exitVal);
            return null;
        }
        return outputfile;
    }

    boolean callJavah(String idlFilename) {
        ProcessOutput normalOutput;
        ProcessOutput errorOutput;
        Process preprocessor;
        String METHOD_NAME = "calljavah";
        ArrayList<String> lineCommand = new ArrayList<String>();
        String[] lineCommandArray = null;
        String fileDir = Util.getIDLFileDirectoryOnly(idlFilename);
        String javafile = (this.m_outputDir != null ? this.m_outputDir : "") + (!this.m_package.isEmpty() ? this.m_package.replace('.', File.separatorChar) + File.separator : "") + Util.getIDLFileNameOnly(idlFilename) + "PubSub.java";
        String headerfile = this.m_outputDir + Util.getIDLFileNameOnly(idlFilename) + "PubSubJNI.h";
        int exitVal = -1;
        String javac = null;
        String javah = null;
        if (this.m_os.contains("Windows")) {
            javac = "javac.exe";
        } else if (this.m_os.contains("Linux") || this.m_os.contains("Mac")) {
            javac = "javac";
        }
        lineCommand.add(javac);
        if (this.m_tempDir != null) {
            lineCommand.add("-d");
            lineCommand.add(this.m_tempDir);
        }
        if (fileDir != null && !fileDir.isEmpty()) {
            lineCommand.add("-sourcepath");
            lineCommand.add(this.m_outputDir);
        }
        lineCommand.add(javafile);
        lineCommandArray = new String[lineCommand.size()];
        lineCommandArray = lineCommand.toArray(lineCommandArray);
        try {
            preprocessor = Runtime.getRuntime().exec(lineCommandArray);
            errorOutput = new ProcessOutput(preprocessor.getErrorStream(), "ERROR", false, null, true);
            normalOutput = new ProcessOutput(preprocessor.getInputStream(), "OUTPUT", false, null, true);
            errorOutput.start();
            normalOutput.start();
            exitVal = preprocessor.waitFor();
            errorOutput.join();
            normalOutput.join();
        }
        catch (Exception ex) {
            System.out.println(ColorMessage.error("calljavah") + "Cannot execute the javac application. Reason: " + ex.getMessage());
            return false;
        }
        if (exitVal != 0) {
            System.out.println(ColorMessage.error("calljavah") + "javac application return an error " + exitVal);
            return false;
        }
        lineCommand = new ArrayList();
        if (this.m_os.contains("Windows")) {
            javah = "javah.exe";
        } else if (this.m_os.contains("Linux") || this.m_os.contains("Mac")) {
            javah = "javah";
        }
        lineCommand.add(javah);
        lineCommand.add("-jni");
        if (this.m_tempDir != null) {
            lineCommand.add("-cp");
            lineCommand.add(this.m_tempDir);
        }
        lineCommand.add("-o");
        lineCommand.add(headerfile);
        lineCommand.add((!this.m_package.isEmpty() ? this.m_package + "." : "") + Util.getIDLFileNameOnly(idlFilename) + "PubSub");
        lineCommandArray = new String[lineCommand.size()];
        lineCommandArray = lineCommand.toArray(lineCommandArray);
        try {
            preprocessor = Runtime.getRuntime().exec(lineCommandArray);
            errorOutput = new ProcessOutput(preprocessor.getErrorStream(), "ERROR", false, null, true);
            normalOutput = new ProcessOutput(preprocessor.getInputStream(), "OUTPUT", false, null, true);
            errorOutput.start();
            normalOutput.start();
            exitVal = preprocessor.waitFor();
            errorOutput.join();
            normalOutput.join();
        }
        catch (Exception ex) {
            System.out.println(ColorMessage.error("calljavah") + "Cannot execute the javah application. Reason: " + ex.getMessage());
            return false;
        }
        if (exitVal != 0) {
            System.out.println(ColorMessage.error("calljavah") + "javah application return an error " + exitVal);
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        ColorMessage.load();
        if (fastrtpsgen.loadPlatforms()) {
            try {
                fastrtpsgen main = new fastrtpsgen(args);
                if (main.execute()) {
                    System.exit(0);
                }
            }
            catch (BadArgumentException e) {
                System.out.println(ColorMessage.error("BadArgumentException") + e.getMessage());
                fastrtpsgen.printHelp();
            }
        }
        System.exit(-1);
    }

    class TemplateErrorListener
    implements StringTemplateErrorListener {
        TemplateErrorListener() {
        }

        @Override
        public void error(String arg0, Throwable arg1) {
            System.out.println(ColorMessage.error() + arg0);
            arg1.printStackTrace();
        }

        @Override
        public void warning(String arg0) {
            System.out.println(ColorMessage.warning() + arg0);
        }
    }

    public static enum LANGUAGE {
        CPP,
        JAVA;

    }
}

