/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.parser.typecode;

import com.eprosima.idl.parser.typecode.PrimitiveTypeCode;
import com.eprosima.idl.parser.typecode.TypeCode;

public class BitfieldSpec {
    private int m_kind = 28;
    private TypeCode m_type = null;
    private String m_scope = null;
    private String m_bitsize = null;

    public BitfieldSpec(String scope, String bitsize, TypeCode type) {
        this.m_scope = scope;
        if (type == null) {
            int size = Integer.parseInt(bitsize);
            if (size == 1) {
                this.m_type = new PrimitiveTypeCode(7);
            } else if (size <= 8) {
                this.m_type = new PrimitiveTypeCode(8);
            } else if (size <= 16) {
                this.m_type = new PrimitiveTypeCode(3);
            } else if (size <= 32) {
                this.m_type = new PrimitiveTypeCode(4);
            } else if (size <= 64) {
                this.m_type = new PrimitiveTypeCode(18);
            }
        } else {
            this.m_type = type;
        }
        this.m_bitsize = bitsize;
    }

    public String getScope() {
        return this.m_scope;
    }

    public boolean getHasScope() {
        return !this.m_scope.isEmpty();
    }

    public String getCppTypename() {
        return this.m_type.getCppTypename();
    }

    public String getCTypename() {
        return this.m_type.getCTypename();
    }

    public String getJavaTypename() {
        return this.m_type.getJavaTypename();
    }

    public String getIdlTypename() {
        if (this.m_type == null) {
            return "bitfield <" + this.m_bitsize + ">";
        }
        return "bitfield <" + this.m_bitsize + ", " + this.m_type.getIdlTypename() + ">";
    }

    public boolean isPrimitive() {
        return true;
    }

    public int getBitSize() {
        if (this.m_bitsize == null) {
            return 0;
        }
        return Integer.parseInt(this.m_bitsize);
    }

    public String getSize() {
        return this.m_type != null ? this.m_type.getSize() : "0";
    }

    public TypeCode getTypecode() {
        return this.m_type;
    }

    public String getInitialValue() {
        return this.m_type.getInitialValue();
    }
}

