/*
 * Decompiled with CFR 0.152.
 */
package com.eprosima.idl.parser.typecode;

import com.eprosima.idl.parser.typecode.Member;
import com.eprosima.idl.parser.typecode.TypeCode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class MemberedTypeCode
extends TypeCode {
    private String m_name = null;
    private String m_scope = null;
    private LinkedHashMap<String, Member> m_members = null;

    protected MemberedTypeCode(int kind, String scope, String name) {
        super(kind);
        this.m_scope = scope;
        this.m_name = name;
        this.m_members = new LinkedHashMap();
    }

    public String getName() {
        return this.m_name;
    }

    public String getScopedname() {
        if (this.m_scope.isEmpty()) {
            return this.m_name;
        }
        return this.m_scope + "::" + this.m_name;
    }

    public String getCScopedname() {
        if (this.m_scope.isEmpty()) {
            return this.m_name;
        }
        return this.m_scope.replace("::", "_") + "_" + this.m_name;
    }

    public String getJavaScopedname() {
        if (this.m_scope.isEmpty()) {
            return this.m_name;
        }
        return this.m_scope.replace("::", ".") + "." + this.m_name;
    }

    public String getJniScopedname() {
        if (this.m_scope.isEmpty()) {
            return this.m_name;
        }
        return this.m_scope.replace("::", "/") + "/" + this.m_name;
    }

    public String getScope() {
        return this.m_scope;
    }

    public boolean getHasScope() {
        return !this.m_scope.isEmpty();
    }

    public List<Member> getMembers() {
        return new ArrayList<Member>(this.m_members.values());
    }

    public boolean addMember(Member member) {
        if (!this.m_members.containsKey(member.getName())) {
            this.m_members.put(member.getName(), member);
            return true;
        }
        return false;
    }

    @Override
    public abstract String getCppTypename();

    @Override
    public abstract String getCTypename();

    @Override
    public abstract String getJavaTypename();

    @Override
    public abstract String getIdlTypename();
}

