# -*- coding: utf-8 -*-
#
# py_trees documentation build configuration file, created by
# sphinx-quickstart on Thu Jul 30 16:43:58 2015.
#
# This file is execfile()d with the current directory set to its
# containing dir.
#
# Note that not all possible configuration values are present in this
# autogenerated file.
#
# All configuration values have a default; values that are commented out
# serve to show the default.

##############################################################################
# Imports
##############################################################################

import os
import sys
import unittest.mock

##############################################################################
# Setup
##############################################################################

# Paths
project_dir = os.path.abspath(
    os.path.join(os.path.abspath(__file__), os.pardir, os.pardir, os.pardir)
)

# Version
version_file = os.path.join(project_dir, "py_trees_ros", "version.py")
with open(version_file) as f:
    exec(f.read())  # makes __version__ available

# Autodoc
sys.path.insert(0, project_dir)

##############################################################################
# Project Information
##############################################################################

project = u'py_trees_ros'
copyright = u'2023, Daniel Stonier'
author = "Daniel Stonier"

version = __version__
release = version

##############################################################################
# Extensions
##############################################################################

extensions = [
    'sphinx.ext.napoleon',
    'sphinx.ext.graphviz',
    'sphinx.ext.intersphinx',
    'sphinx.ext.coverage',
    'sphinx.ext.doctest',
    'sphinx.ext.ifconfig',
    'sphinx.ext.autodoc',
    'sphinx.ext.autosummary',
    'sphinx.ext.mathjax',
    'sphinx.ext.todo',
    'sphinx.ext.viewcode',
    'sphinxarg.ext',
    'sphinx.ext.autodoc.typehints'
    # Broken with latest sphinx / mock
    # https://github.com/tox-dev/sphinx-autodoc-typehints/issues/220
    # 'sphinx_autodoc_typehints',
]

##############################################################################
# Extension Configuration
##############################################################################

autodoc_typehints = "description"

# True to use the :ivar: role for instance variables.
# False to use the .. attribute:: directive instead.
napoleon_use_ivar = True

# If you don't add this, todos don't appear
todo_include_todos = True

##############################################################################
# Regular Sphinx Configuration
##############################################################################

templates_path = ["_templates"]
exclude_patterns = ["_build", "weblinks.rst"]
language = "en"

################################################################################
# HTML
# https://www.sphinx-doc.org/en/master/usage/configuration.html#options-for-html-output
################################################################################

html_theme = "sphinx_rtd_theme"

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = []

# If true, “(C) Copyright …” is shown in the HTML footer. Default is True.
html_show_copyright = False

# If true, "Created using Sphinx" is shown in the HTML footer. Default is True.
html_show_sphinx = False

##############################################################################
# Intersphinx
##############################################################################

intersphinx_mapping = {
    'python': ('https://docs.python.org/3', None),
    'py_trees': ('https://py-trees.readthedocs.io/en/release-2.2.x', None),
    'py_trees_ros_tutorials': ('https://py-trees-ros-tutorials.readthedocs.io/en/release-2.1.x', None),
    'rclpy': ('https://docs.ros2.org/foxy/api/rclpy/', None),
}


##############################################################################
# Autodoc Mocks
##############################################################################


# Caveats: Currently autodoc is failing on classes which
# inherit from a mocked class. I don't know if this is a bug
# in sphinx, or something I'm not implementing correctly.

# Workaround: I only inherit from py_trees, so make sure that
# is in the environment and not mocked.


MOCK_MODULES = [
    'action_msgs', 'action_msgs.msg',
    'diagnostic_msgs', 'diagnostic_msgs.msg',
    'geometry_msgs', 'geometry_msgs.msg',
    'py_trees_ros_interfaces', 'py_trees_ros_interfaces.action',
    'py_trees_ros_interfaces.msg', 'py_trees_ros_interfaces.srv',
    'rcl_interfaces', 'rcl_interfaces.msg',
    'ros2cli', 'ros2cli.node', 'ros2cli.node.strategy',
    'ros2topic', 'ros2topic.api',
    'sensor_msgs', 'sensor_msgs.msg',
    'std_msgs', 'std_msgs.msg',
    'tf2_ros',
    'unique_identifier_msgs', 'unique_identifier_msgs.msg'
]

for mod_name in MOCK_MODULES:
    sys.modules[mod_name] = unittest.mock.Mock()

# A few modules are not available for import in the local environment
# but do have information available via intersphinx mappings (and hence
# don't need to be mocked as above). These will break autodoc when it
# tries to import them, so at least mock the imports.
autodoc_mock_imports = [
    "rclpy"
]
