## Background Information on Intermediate Waypoints

In comparison to the Community Version, Ruckig Pro allows to generate more complex trajectories defined by *intermediate waypoints*. Therefore, Ruckig takes a list of positions as input and calculates a trajectory reaching them successively before moving to the target state. As this is a much harder problem than solving state-to-state motions (as the Community Version does), Ruckig Pro is not able to guarantee for a *time-optimal* trajectory. In fact, trajectory planning with intermediate waypoints is a non-convex problem and therefore NP-hard. However, Ruckig calculates much faster trajectories than other approaches for a wide range of trajectory types, primarily due to the joint calculation of the path and its time parametrization. On top, Ruckig is real-time capable and considers jerk-constraints.

In this regard, following information help to obtain robust and ideal optimization results:
 1. Ruckig guarantees to output trajectories faster than a trajectory stopping at each intermediate waypoint (with zero velocity and acceleration).
 2. Ruckig prefers as few waypoints as possible, both improving the (relative) trajectory duration as well as the computational performance. Note that the complexity of the calculation increases with the number of waypoints, in contrast to many other (time-parametrization) approaches that scale with the trajectory duration or path length. While Ruckig is tested with 50+ waypoints, we strongly recommend to limit the number of waypoints to a single-digit number.
 3. Ruckig prefers waypoints that are far away from each other (relative to the given velocity limit) and not positioned in a straight line. When using waypoints from a motion planning algorithm (such as RRT), we strongly recommend to pre-process your list by a waypoint filter (such as the integrated `Ruckig::filter_intermediate_positions` method) first. Fortunately, a straight line of dozens of waypoints is not a typical use-case seeking for near time-optimal trajectories. For a single DoF, Ruckig automatically filters waypoints without loss of generality.
