(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    194821,       5124]
NotebookOptionsPosition[    184741,       4957]
NotebookOutlinePosition[    185141,       4973]
CellTagsIndexPosition[    185098,       4970]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell["Ruckig Step 1", "Text",
 CellChangeTimes->{{3.8174628076007547`*^9, 3.817462833050323*^9}, {
  3.820307235551709*^9, 
  3.820307236485478*^9}},ExpressionUUID->"f0efc888-777d-4c66-b8e6-\
2db88daacc31"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"jerkProfile", "=", 
   RowBox[{"{", 
    RowBox[{"jMax", ",", "0", ",", 
     RowBox[{"-", "jMax"}], ",", "0", ",", 
     RowBox[{"-", "jMax"}], ",", "0", ",", "jMax"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"tVars", "=", 
    RowBox[{"{", 
     RowBox[{
     "t1", ",", "t2", ",", "t3", ",", "t4", ",", "t5", ",", "t6", ",", "t7"}],
      "}"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a1", "=", 
   RowBox[{"a0", "+", 
    RowBox[{"t1", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a2", "=", 
   RowBox[{"a1", "+", 
    RowBox[{"t2", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a3", "=", 
   RowBox[{"a2", "+", 
    RowBox[{"t3", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a4", "=", 
   RowBox[{"a3", "+", 
    RowBox[{"t4", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a5", "=", 
   RowBox[{"a4", "+", 
    RowBox[{"t5", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"a6", "=", 
   RowBox[{"a5", "+", 
    RowBox[{"t6", " ", 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a7", "=", 
    RowBox[{"a6", "+", 
     RowBox[{"t7", " ", 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v1", "=", 
   RowBox[{"v0", "+", 
    RowBox[{"t1", " ", "a0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v2", "=", 
   RowBox[{"v1", "+", 
    RowBox[{"t2", " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t2", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v3", "=", 
   RowBox[{"v2", "+", 
    RowBox[{"t3", " ", "a2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v4", "=", 
   RowBox[{"v3", "+", 
    RowBox[{"t4", " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t4", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v5", "=", 
   RowBox[{"v4", "+", 
    RowBox[{"t5", " ", "a4"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"v6", "=", 
   RowBox[{"v5", "+", 
    RowBox[{"t6", " ", "a5"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t6", "2"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"v7", "=", 
    RowBox[{"v6", "+", 
     RowBox[{"t7", " ", "a6"}], "+", 
     RowBox[{
      FractionBox["1", "2"], 
      SuperscriptBox["t7", "2"], 
      RowBox[{"jerkProfile", "[", 
       RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p1", "=", 
   RowBox[{"p0", "+", 
    RowBox[{"t1", " ", "v0"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t1", "2"], " ", "a0"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t1", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p2", "=", 
   RowBox[{"p1", "+", 
    RowBox[{"t2", " ", "v1"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t2", "2"], " ", "a1"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t2", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p3", "=", 
   RowBox[{"p2", "+", 
    RowBox[{"t3", " ", "v2"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t3", "2"], " ", "a2"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t3", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "3", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p4", "=", 
   RowBox[{"p3", "+", 
    RowBox[{"t4", " ", "v3"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t4", "2"], " ", "a3"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t4", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "4", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p5", "=", 
   RowBox[{"p4", "+", 
    RowBox[{"t5", " ", "v4"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t5", "2"], " ", "a4"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t5", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "5", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p6", "=", 
   RowBox[{"p5", "+", 
    RowBox[{"t6", " ", "v5"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t6", "2"], " ", "a5"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t6", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "6", "]"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"p7", "=", 
   RowBox[{"p6", "+", 
    RowBox[{"t7", " ", "v6"}], "+", 
    RowBox[{
     FractionBox["1", "2"], 
     SuperscriptBox["t7", "2"], " ", "a6"}], "+", 
    RowBox[{
     FractionBox["1", "6"], 
     SuperscriptBox["t7", "3"], 
     RowBox[{"jerkProfile", "[", 
      RowBox[{"[", "7", "]"}], "]"}]}]}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.817462841378334*^9, 3.817462900269423*^9}, {
   3.8176136118348*^9, 3.8176136203885107`*^9}, 3.817613860612129*^9, 
   3.817615902502871*^9, 3.817628855244062*^9, 3.817628926525811*^9, 
   3.817630327779182*^9, 3.817630856882971*^9, 3.817631232893464*^9, 
   3.817631310598453*^9, 3.817640134759371*^9, 3.818009215253849*^9, {
   3.819365329290554*^9, 3.819365331663157*^9}, 3.820148038073226*^9, {
   3.8205597423263273`*^9, 3.820559744425127*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"d346b209-9dd3-47cf-8f1e-f04bc3bf980a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"resultT", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars"}], "]"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMin"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"v3", "\[Equal]", "vMax"}]}], "}"}], ",", "tVars"}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", 
          RowBox[{"-", "aMax"}]}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a3", "\[Equal]", "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"v7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "vf"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"p7", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "pf"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a3", "/.", 
            RowBox[{"{", 
             RowBox[{"a0", "\[Rule]", "0"}], "}"}]}], ")"}], "\[Equal]", 
          "0"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"a1", "\[Equal]", "aMax"}], ",", 
         RowBox[{"t6", "\[Equal]", "0"}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}], ",", 
         RowBox[{"t5", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Solve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"a7", "\[Equal]", "af"}], ",", 
         RowBox[{"v7", "\[Equal]", "vf"}], ",", 
         RowBox[{"p7", "\[Equal]", "pf"}], ",", 
         RowBox[{"t2", "\[Equal]", "0"}], ",", 
         RowBox[{"a5", "\[Equal]", 
          RowBox[{"-", "aMax"}]}], ",", 
         RowBox[{"t4", "\[Equal]", "0"}], ",", 
         RowBox[{"t5", "\[Equal]", "0"}]}], "}"}], ",", "tVars", ",", 
       RowBox[{"Cubics", "\[Rule]", "False"}], ",", 
       RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}], 
    "\[IndentingNewLine]", "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.8174629257969522`*^9, 3.817462978356163*^9}, {
   3.817463017710661*^9, 3.817463019150318*^9}, {3.817463125060719*^9, 
   3.817463268801898*^9}, {3.8174633497876797`*^9, 3.817463350013275*^9}, {
   3.8176142815731697`*^9, 3.817614282974786*^9}, 3.817629135081959*^9, 
   3.817629174090706*^9, {3.817629395753993*^9, 3.817629397914218*^9}, {
   3.817629903651003*^9, 3.81762990789653*^9}, 3.817630008980739*^9, {
   3.8176308336239557`*^9, 3.8176308355038147`*^9}, 3.8176412855214357`*^9, {
   3.819480271236746*^9, 3.819480275524906*^9}, {3.820559923457724*^9, 
   3.820559934200976*^9}, {3.820560449143613*^9, 3.820560470192191*^9}, {
   3.821871609794586*^9, 3.821871622909561*^9}},
 CellLabel->"In[25]:=",ExpressionUUID->"ccba75f7-892e-4119-93ec-41811b2e330e"],

Cell["\<\
Information Roots are max. 4th Order
- (1) Case 1: Acc0_Acc1_Vel: Solution 1 (Length 1)
- (2) Case 2: Acc0_Acc1: Solution 1/2 (UDDU) (Length 2)
- (3) Case 3: Acc1_Vel: Solution 2 (Length 2)
- (4) Case 4: Acc0_Vel: Solution 1/2 (Length 2)
- (5) Case 5: Vel: Solution 3/4 (Length 4)
- (6) Case 6a: Acc1: Root in t1 (Length 4)
- (7) Case 6b: Acc1: Root in t1 (UDUD for af != 0) (Length 4)
- (8) Case 7: Acc0: Root in t5 (Length 4)
- (9) Case 8: None: Root in t1, (UDDU), (UDUD for af != 0) (Length 4)
- (10) Case 8: None: Root in t1, (UDDU), (UDUD for af != 0) with a0==af==0 \
(Length 4)
- (11) Case 7: Acc0: Root in t3 (Length 4)
- (12) Case 6: Acc1: Root in t1 (Length 4)\
\>", "Text",
 CellChangeTimes->{{3.8174632785384893`*^9, 3.817463379445586*^9}, {
   3.8174635726156178`*^9, 3.817463721259947*^9}, {3.8174665706088743`*^9, 
   3.817466570913156*^9}, {3.817467118701497*^9, 3.8174671190303392`*^9}, {
   3.8174674657907257`*^9, 3.8174674659023438`*^9}, {3.817616051327691*^9, 
   3.817616061734858*^9}, {3.8176181077496033`*^9, 3.817618117117276*^9}, {
   3.81762928092439*^9, 3.817629317932926*^9}, {3.817629348645948*^9, 
   3.817629405422893*^9}, {3.81762991338601*^9, 3.817629922653615*^9}, {
   3.817630011713861*^9, 3.8176300169571753`*^9}, {3.817630830414349*^9, 
   3.81763085334088*^9}, {3.8176412891511297`*^9, 3.8176412957587967`*^9}, 
   3.817700725859343*^9, {3.817700767970825*^9, 3.81770076813795*^9}, {
   3.819480286564745*^9, 3.819480293963434*^9}, {3.819707143963235*^9, 
   3.8197071909725227`*^9}, {3.820559944751623*^9, 3.8205599501398993`*^9}, {
   3.820560944238277*^9, 
   3.820560967704018*^9}},ExpressionUUID->"e82cb2e9-b4f4-4bc2-9a74-\
547157d3c4dc"],

Cell["\<\
Print Cases 1-5
[[Case, Solution, Time Number, 2]]\
\>", "Text",
 CellChangeTimes->{{3.817463738997243*^9, 3.817463742980877*^9}, {
  3.817463775486054*^9, 
  3.817463786446526*^9}},ExpressionUUID->"2bb13fa1-f9ef-4a5d-ac3b-\
101e020ad421"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"resultT", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<Solutions: \>\"", "<>", 
  RowBox[{"ToString", "[", 
   RowBox[{"Length", "[", "tmpResult", "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Refine", "[", 
     RowBox[{"tmpResult", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "6", ",", "2"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"vMax", "\[Element]", "Reals"}], ",", 
      RowBox[{"aMax", "\[Element]", "Reals"}], ",", 
      RowBox[{"jMax", "\[Element]", "Reals"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQAWIQPe+tx03rwjeOdZEuD0B0Ilf/VxBto7f/L4huu+ns
bgOkG7hdPEC01zVjO1sgbWH4zgFE/7i/yQVMs31wA9HLpu8IAdEaN3aC6R/5
ayNBtNbR2kQQXbHdNBNEu21fXQA2R5inHESLRP+oBeuvf9IEonNEUjpA9Jz7
UlNAtFetyCoQPe/u5P0gOi8g9RSIrvm/914PkN7z+gOYvpBw+imI1rqo8QZM
13QtmQSkDbbt2Qqi92733rMeSPf4GxwE0XeE4s4ql79xnOjCcA5EG53kdFpS
+cZRZo6dN4h+1SaVCKL3cTHlguhu1V9FILqwYVoJiAYAKjqh/w==
  "],
 CellLabel->
  "In[161]:=",ExpressionUUID->"f20278fb-5b15-4c9c-bd38-9f1d3931e2f3"],

Cell[BoxData["\<\"Solutions: 2\"\>"], "Output",
 CellChangeTimes->{{3.817463508059903*^9, 3.817463555229458*^9}, 
   3.817463726805722*^9, {3.817463761974618*^9, 3.81746379044567*^9}, {
   3.817464381894802*^9, 3.8174643873252087`*^9}, {3.8174663563162394`*^9, 
   3.817466375946266*^9}, {3.817466406939005*^9, 3.817466424056478*^9}, {
   3.817466528510715*^9, 3.8174665342047358`*^9}, {3.81746657390097*^9, 
   3.817466637425099*^9}, {3.817466700379902*^9, 3.817466757898581*^9}, {
   3.8174668106271133`*^9, 3.817466864238778*^9}, {3.8174669050556927`*^9, 
   3.8174669476340647`*^9}, {3.8174670349764433`*^9, 3.817467217464361*^9}, {
   3.817467389302877*^9, 3.8174674761335993`*^9}, 3.8176294327019367`*^9, {
   3.817629487238022*^9, 3.8176295375030212`*^9}, {3.817641270569572*^9, 
   3.817641390401013*^9}, {3.817700838931745*^9, 3.817700873737822*^9}, {
   3.820559979771512*^9, 3.820559984275301*^9}, {3.8218716334083567`*^9, 
   3.8218717064697647`*^9}, {3.821871882114599*^9, 3.821871976452033*^9}, {
   3.821872025084113*^9, 3.821872037057416*^9}},
 CellLabel->
  "Out[162]=",ExpressionUUID->"4cd7848d-fdf9-4f4e-b495-1bf7e99dc1bd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"6", " ", 
    RowBox[{"(", 
     RowBox[{"aMax", "-", "aMin"}], ")"}], " ", "aMin", " ", 
    SuperscriptBox["jMax", "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     RowBox[{"(", 
      RowBox[{"aMax", "-", "aMin"}], ")"}], " ", "jMax", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["af", "2"], "+", 
       RowBox[{"aMax", " ", "aMin"}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["aMin", "2"], "+", 
          RowBox[{"jMax", " ", "vf"}]}], ")"}]}]}], ")"}]}], "+", 
    RowBox[{
     SqrtBox["3"], " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"aMax", "-", "aMin"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"3", " ", 
           SuperscriptBox["af", "4"], " ", "aMax"}], "-", 
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"], " ", "aMin"}], "+", 
          RowBox[{"8", " ", 
           SuperscriptBox["a0", "3"], " ", "aMax", " ", "aMin"}], "-", 
          RowBox[{"8", " ", 
           SuperscriptBox["af", "3"], " ", "aMax", " ", "aMin"}], "-", 
          RowBox[{
          "24", " ", "a0", " ", "aMax", " ", "aMin", " ", "jMax", " ", "v0"}],
           "-", 
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "2"], " ", "aMin", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["aMax", "2"], "-", 
             RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "+", 
          RowBox[{
          "24", " ", "af", " ", "aMax", " ", "aMin", " ", "jMax", " ", "vf"}],
           "+", 
          RowBox[{"6", " ", 
           SuperscriptBox["af", "2"], " ", "aMax", " ", 
           RowBox[{"(", 
            RowBox[{
             SuperscriptBox["aMin", "2"], "-", 
             RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["aMax", "3"], " ", 
              SuperscriptBox["aMin", "2"]}], "-", 
             RowBox[{"4", " ", "aMin", " ", 
              SuperscriptBox["jMax", "2"], " ", 
              SuperscriptBox["v0", "2"]}], "-", 
             RowBox[{
              SuperscriptBox["aMax", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                SuperscriptBox["aMin", "3"], "-", 
                RowBox[{"4", " ", "aMin", " ", "jMax", " ", "v0"}]}], ")"}]}],
              "+", 
             RowBox[{"4", " ", "aMax", " ", "jMax", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", "aMin", " ", "jMax", " ", 
                 RowBox[{"(", 
                  RowBox[{"p0", "-", "pf"}], ")"}]}], "-", 
                RowBox[{
                 SuperscriptBox["aMin", "2"], " ", "vf"}], "+", 
                RowBox[{"jMax", " ", 
                 SuperscriptBox["vf", "2"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}],
        ")"}]}], " ", 
     RowBox[{"Abs", "[", "jMax", "]"}]}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.817463508059903*^9, 3.817463555229458*^9}, 
   3.817463726805722*^9, {3.817463761974618*^9, 3.81746379044567*^9}, {
   3.817464381894802*^9, 3.8174643873252087`*^9}, {3.8174663563162394`*^9, 
   3.817466375946266*^9}, {3.817466406939005*^9, 3.817466424056478*^9}, {
   3.817466528510715*^9, 3.8174665342047358`*^9}, {3.81746657390097*^9, 
   3.817466637425099*^9}, {3.817466700379902*^9, 3.817466757898581*^9}, {
   3.8174668106271133`*^9, 3.817466864238778*^9}, {3.8174669050556927`*^9, 
   3.8174669476340647`*^9}, {3.8174670349764433`*^9, 3.817467217464361*^9}, {
   3.817467389302877*^9, 3.8174674761335993`*^9}, 3.8176294327019367`*^9, {
   3.817629487238022*^9, 3.8176295375030212`*^9}, {3.817641270569572*^9, 
   3.817641390401013*^9}, {3.817700838931745*^9, 3.817700873737822*^9}, {
   3.820559979771512*^9, 3.820559984275301*^9}, {3.8218716334083567`*^9, 
   3.8218717064697647`*^9}, {3.821871882114599*^9, 3.821871976452033*^9}, {
   3.821872025084113*^9, 3.821872037181758*^9}},
 CellLabel->
  "Out[163]=",ExpressionUUID->"72d60704-2911-4ccb-8d4c-6119a0a66aa5"]
}, Open  ]],

Cell["Print Cases 6-8: Roots", "Text",
 CellChangeTimes->{{3.817463796484267*^9, 
  3.8174638010307283`*^9}},ExpressionUUID->"8d7af2fe-a47e-4ef4-b28a-\
db0dc764dd0f"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tRoot", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"resultT", "[", 
    RowBox[{"[", 
     RowBox[{"12", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootFunction", "=", 
   RowBox[{"tmpResult", "[", 
    RowBox[{"[", 
     RowBox[{"tRoot", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Last", "[", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "]"}]], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.81746385324234*^9, 3.8174638588074417`*^9}, {
   3.8174639004090853`*^9, 3.817464146400536*^9}, {3.817464197682095*^9, 
   3.8174642237071457`*^9}, {3.81746467517737*^9, 3.817464733015148*^9}, {
   3.8174647716155567`*^9, 3.817464808121599*^9}, {3.817464958295774*^9, 
   3.817464978456039*^9}, {3.817465392157484*^9, 3.8174654363653917`*^9}, {
   3.8174655875222387`*^9, 3.817465641579135*^9}, {3.8174662104318943`*^9, 
   3.817466215391354*^9}, {3.817466254017514*^9, 3.817466312191326*^9}, 
   3.817473469655705*^9, {3.817616070193791*^9, 3.8176160704001007`*^9}, {
   3.817616106402553*^9, 3.817616138705028*^9}, {3.81761645464653*^9, 
   3.817616521373534*^9}, {3.817618123606201*^9, 3.817618152793016*^9}, {
   3.8180094803954144`*^9, 3.818009506714346*^9}, {3.8180099934634867`*^9, 
   3.818010051334861*^9}, {3.820559959748899*^9, 3.820559975599066*^9}, {
   3.8205600482286043`*^9, 3.820560058937006*^9}, {3.8205609693602257`*^9, 
   3.82056101111698*^9}},
 CellLabel->
  "In[2429]:=",ExpressionUUID->"ca8158ca-2cc6-4c2b-92b0-ae9728cb14cd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"12", " ", 
    SuperscriptBox["jMax", "4"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["a0", "4"]}], "-", 
    RowBox[{"3", " ", 
     SuperscriptBox["af", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a0", "3"], " ", "aMax"}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["af", "3"], " ", "aMax"}], "+", 
    RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", "v0"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["a0", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "+", 
       RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "+", 
    RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", "vf"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["af", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
    RowBox[{"12", " ", "jMax", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{"p0", "-", "pf"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["aMax", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"v0", "+", "vf"}], ")"}]}], "+", 
       RowBox[{"jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["v0", "2"], "-", 
          SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{
  3.817464224080229*^9, {3.8174646757284613`*^9, 3.817464735056591*^9}, {
   3.817464772067339*^9, 3.817464808446479*^9}, {3.8174649500267267`*^9, 
   3.817464979046924*^9}, {3.8174653964553947`*^9, 3.81746543673561*^9}, {
   3.817465591806774*^9, 3.817465642153749*^9}, 3.817466216455537*^9, {
   3.817466257823419*^9, 3.817466313043701*^9}, {3.8174734582456903`*^9, 
   3.8174734702907677`*^9}, {3.817616067838916*^9, 3.817616070838888*^9}, {
   3.817616106894815*^9, 3.817616139189769*^9}, {3.817616459558393*^9, 
   3.817616521866693*^9}, {3.817618128281868*^9, 3.817618153255725*^9}, {
   3.818009482010332*^9, 3.818009507179964*^9}, {3.8180100256655703`*^9, 
   3.818010051730009*^9}, {3.820559960277973*^9, 3.820559998336207*^9}, {
   3.820560048573118*^9, 3.820560059189855*^9}, {3.8205609713678093`*^9, 
   3.8205610115364027`*^9}},
 CellLabel->
  "Out[2432]=",ExpressionUUID->"0a94f786-574e-4852-9434-e6c9207268ec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpReplaced", "=", 
   RowBox[{"tmpResult", "//.", 
    RowBox[{"{", 
     RowBox[{"rootFunction", "\[Rule]", "t"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"tmpReplaced", "[", 
    RowBox[{"[", 
     RowBox[{"7", ",", "2"}], "]"}], "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.817464186795458*^9, 3.817464336782579*^9}, {
  3.8174648872943287`*^9, 3.8174649200286627`*^9}, {3.8174649939680443`*^9, 
  3.8174650073602333`*^9}, {3.817465402901187*^9, 3.817465413129187*^9}, {
  3.817465468359084*^9, 3.817465497350111*^9}, {3.8174656551333303`*^9, 
  3.817465701685096*^9}, {3.817473479559062*^9, 3.8174734800856733`*^9}, {
  3.817473533672271*^9, 3.817473533751308*^9}, {3.8174742089250727`*^9, 
  3.817474210971596*^9}, {3.817616151988146*^9, 3.817616183627185*^9}, {
  3.817618162951096*^9, 3.8176181782700644`*^9}, {3.818009517172654*^9, 
  3.818009538091856*^9}, {3.8180100608100224`*^9, 3.81801007299201*^9}, {
  3.82055999962952*^9, 3.820560013274135*^9}, {3.820560085140555*^9, 
  3.820560097165331*^9}, {3.820561025609236*^9, 3.82056106283314*^9}},
 CellLabel->
  "In[2455]:=",ExpressionUUID->"02ddacce-ea40-40b5-bbc9-e4e0e8a8500b"],

Cell[BoxData[
 FractionBox[
  RowBox[{"af", "+", "aMax"}], "jMax"]], "Output",
 CellChangeTimes->{{3.817464289219615*^9, 3.817464337401743*^9}, {
   3.817464881225731*^9, 3.817464920476918*^9}, {3.817464988238978*^9, 
   3.81746500768358*^9}, {3.81746540086765*^9, 3.817465413431589*^9}, {
   3.817465461523279*^9, 3.817465497766103*^9}, {3.817465655693458*^9, 
   3.817465703495722*^9}, 3.817466232751576*^9, 3.817473410326756*^9, {
   3.817473459931615*^9, 3.8174734881471148`*^9}, 3.81747354157975*^9, {
   3.81747420945721*^9, 3.8174742112747707`*^9}, {3.8176161501097183`*^9, 
   3.817616185177759*^9}, {3.817618163459977*^9, 3.817618178516623*^9}, {
   3.818009517630191*^9, 3.8180095385414467`*^9}, {3.8180100612506733`*^9, 
   3.8180100732781763`*^9}, {3.820559999924418*^9, 3.820560013605125*^9}, {
   3.820560081633182*^9, 3.820560097566641*^9}, {3.820561026013336*^9, 
   3.820561063323831*^9}},
 CellLabel->
  "Out[2456]=",ExpressionUUID->"cd5c1068-df37-4f84-8783-2e31418f59b2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmpData", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"p0", "\[Rule]", 
      RowBox[{"-", "2.5"}]}], ",", 
     RowBox[{"v0", "\[Rule]", "4.0"}], ",", 
     RowBox[{"a0", "\[Rule]", "0.1"}], ",", 
     RowBox[{"pf", "\[Rule]", "10.0"}], ",", 
     RowBox[{"vf", "\[Rule]", "3.2"}], ",", 
     RowBox[{"af", "\[Rule]", "0.0"}], ",", 
     RowBox[{"vMax", "\[Rule]", 
      RowBox[{"-", "10.0"}]}], ",", 
     RowBox[{"aMax", "\[Rule]", 
      RowBox[{"-", "15.0"}]}], ",", 
     RowBox[{"jMax", "\[Rule]", 
      RowBox[{"-", "1.0"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"resultT", "[", 
    RowBox[{"[", "10", "]"}], "]"}], "/.", 
   "tmpData"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "t1", "+", "t2", "+", "t3", "+", "t4", "+", "t5", "+", "t6", "+", "t7"}], "/.",
   "tmp"}]}], "Input",
 CellChangeTimes->{{3.817628868625602*^9, 3.817628918025359*^9}, {
  3.817628948475369*^9, 3.817628952074409*^9}, {3.8176291487769613`*^9, 
  3.817629204826724*^9}, {3.817629418857974*^9, 3.817629418944375*^9}, {
  3.817629814321773*^9, 3.817629882142076*^9}, {3.817629937474257*^9, 
  3.81762995982032*^9}, {3.817630093056933*^9, 3.8176302846866693`*^9}, {
  3.8176303368336554`*^9, 3.817630500333248*^9}, {3.817630532955221*^9, 
  3.817630534820991*^9}, {3.817630866367572*^9, 3.817630892543679*^9}, {
  3.8176401628006353`*^9, 3.817640175272009*^9}, {3.817640319973881*^9, 
  3.817640321634637*^9}, {3.817640356332087*^9, 3.817640413113693*^9}, {
  3.8176407987176323`*^9, 3.817640897721925*^9}},
 CellLabel->"In[74]:=",ExpressionUUID->"bbf1a9de-0221-4992-b9c6-d1f769287d62"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", 
      RowBox[{"-", "3.000078051472521`"}]}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", 
      RowBox[{"-", "3.1000780514725212`"}]}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", 
      RowBox[{"-", "2.967403566288493`"}]}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", 
      RowBox[{"-", "2.9674035662884917`"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "1.2653161258674266`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "1.1653161258674265`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", "0.7436139275233279`"}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", "0.7436139275233278`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "2.269630566608486`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "2.169630566608486`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", "1.9754231940427`"}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", "1.9754231940427`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t1", "\[Rule]", "29.92641500288895`"}], ",", 
     RowBox[{"t2", "\[Rule]", "0"}], ",", 
     RowBox[{"t3", "\[Rule]", "29.82641500288895`"}], ",", 
     RowBox[{"t4", "\[Rule]", "0"}], ",", 
     RowBox[{"t5", "\[Rule]", 
      RowBox[{"-", "29.812917199169515`"}]}], ",", 
     RowBox[{"t6", "\[Rule]", "0"}], ",", 
     RowBox[{"t7", "\[Rule]", 
      RowBox[{"-", "29.8129171991696`"}]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.81762887322018*^9, 3.8176289522859573`*^9}, {
   3.817629144469183*^9, 3.8176292052480793`*^9}, 3.817629419378545*^9, {
   3.817629824717011*^9, 3.817629882642803*^9}, {3.817629932753271*^9, 
   3.817629960221161*^9}, {3.817630093843822*^9, 3.8176302850623083`*^9}, {
   3.8176303374042883`*^9, 3.817630535828087*^9}, {3.817630868464644*^9, 
   3.817630892873412*^9}, {3.81764016451027*^9, 3.8176401760537167`*^9}, 
   3.8176403225928097`*^9, {3.817640357057991*^9, 3.817640414142352*^9}, {
   3.817640804181323*^9, 3.8176408985731688`*^9}},
 CellLabel->"Out[75]=",ExpressionUUID->"105051c1-dd97-49a1-a1ea-1856a027794e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "12.034963235522028`"}], ",", "3.9178601067815086`", ",", 
   "8.390107521302372`", ",", "0.12699560743878635`"}], "}"}]], "Output",
 CellChangeTimes->{{3.81762887322018*^9, 3.8176289522859573`*^9}, {
   3.817629144469183*^9, 3.8176292052480793`*^9}, 3.817629419378545*^9, {
   3.817629824717011*^9, 3.817629882642803*^9}, {3.817629932753271*^9, 
   3.817629960221161*^9}, {3.817630093843822*^9, 3.8176302850623083`*^9}, {
   3.8176303374042883`*^9, 3.817630535828087*^9}, {3.817630868464644*^9, 
   3.817630892873412*^9}, {3.81764016451027*^9, 3.8176401760537167`*^9}, 
   3.8176403225928097`*^9, {3.817640357057991*^9, 3.817640414142352*^9}, {
   3.817640804181323*^9, 3.817640898574758*^9}},
 CellLabel->"Out[76]=",ExpressionUUID->"ee561e7d-9711-4560-80d9-d30648c0977e"]
}, Open  ]],

Cell["UDUD Time Minimization", "CodeText",
 CellChangeTimes->{{3.820148045831812*^9, 3.820148047965917*^9}, {
  3.820149510658725*^9, 
  3.820149514583879*^9}},ExpressionUUID->"3f45e156-5cf9-44e3-af10-\
aa1a13b499e9"],

Cell[BoxData[
 RowBox[{
  RowBox[{"tAll", "=", 
   RowBox[{
   "t1", "+", "t2", "+", "t3", "+", "t4", "+", "t5", "+", "t6", "+", "t7"}]}],
   ";"}]], "Input",
 CellChangeTimes->{3.820473045035326*^9},
 CellLabel->
  "In[898]:=",ExpressionUUID->"e818af86-de53-4897-8691-2be2441cd16a"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"t1r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a1", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t4", "\[Rule]", "0"}], ",", 
         RowBox[{"t6", "\[Rule]", "0"}], ",", 
         RowBox[{"t7", "\[Rule]", "0"}]}], "}"}]}], ")"}], "\[Equal]", 
     "aMax"}], ",", "t1"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t5r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a7", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t4", "\[Rule]", "0"}], ",", 
          RowBox[{"t6", "\[Rule]", "0"}], ",", 
          RowBox[{"t7", "\[Rule]", "0"}]}], "}"}]}], "/.", "t1r"}], ")"}], 
     "\[Equal]", "af"}], ",", "t5"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t2r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"v7", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t4", "\[Rule]", "0"}], ",", 
           RowBox[{"t6", "\[Rule]", "0"}], ",", 
           RowBox[{"t7", "\[Rule]", "0"}]}], "}"}]}], "/.", 
        RowBox[{"t1r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t5r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "vf"}], ",", 
    "t2"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t3r", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"p7", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"t4", "\[Rule]", "0"}], ",", 
             RowBox[{"t6", "\[Rule]", "0"}], ",", 
             RowBox[{"t7", "\[Rule]", "0"}]}], "}"}]}], "/.", 
          RowBox[{"t1r", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
         RowBox[{"t5r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t2r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "pf"}], ",", 
     "t3", ",", 
     RowBox[{"Quartics", "\[Rule]", "False"}], ",", 
     RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.820469812563943*^9, 3.820469967517128*^9}, 
   3.8204699986005917`*^9, {3.8204700934727287`*^9, 3.820470232867256*^9}, {
   3.820470298681115*^9, 3.820470358351329*^9}, {3.820470429393427*^9, 
   3.820470452927017*^9}, {3.820477185910329*^9, 3.820477255613295*^9}, {
   3.820478647842174*^9, 3.820478664088344*^9}, {3.820479471360922*^9, 
   3.82047948993532*^9}, {3.820479718091106*^9, 3.820479773051201*^9}},
 CellLabel->
  "In[1612]:=",ExpressionUUID->"d8d6b366-35dd-4052-aa2e-094a5ea14d30"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t1", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a0"}], "+", "aMax"}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820469808107897*^9, 3.8204698547852592`*^9}, {
   3.820469885371089*^9, 3.82046996780054*^9}, 3.8204699993460207`*^9, {
   3.820470101023305*^9, 3.8204702334585743`*^9}, 3.820470299336344*^9, {
   3.820470333532864*^9, 3.820470358630972*^9}, {3.82047043212789*^9, 
   3.8204704753207808`*^9}, 3.8204706260831137`*^9, {3.820477186652748*^9, 
   3.820477257028311*^9}, {3.820478648120041*^9, 3.820478664517067*^9}, {
   3.8204794722087097`*^9, 3.820479492325042*^9}, {3.820479721136821*^9, 
   3.8204797736597767`*^9}},
 CellLabel->
  "Out[1612]=",ExpressionUUID->"c9cf3bd0-d0c1-4283-a30b-fc90574f3520"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t5", "\[Rule]", 
    FractionBox[
     RowBox[{"af", "-", "aMax", "+", 
      RowBox[{"jMax", " ", "t3"}]}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820469808107897*^9, 3.8204698547852592`*^9}, {
   3.820469885371089*^9, 3.82046996780054*^9}, 3.8204699993460207`*^9, {
   3.820470101023305*^9, 3.8204702334585743`*^9}, 3.820470299336344*^9, {
   3.820470333532864*^9, 3.820470358630972*^9}, {3.82047043212789*^9, 
   3.8204704753207808`*^9}, 3.8204706260831137`*^9, {3.820477186652748*^9, 
   3.820477257028311*^9}, {3.820478648120041*^9, 3.820478664517067*^9}, {
   3.8204794722087097`*^9, 3.820479492325042*^9}, {3.820479721136821*^9, 
   3.820479773664441*^9}},
 CellLabel->
  "Out[1613]=",ExpressionUUID->"8333c215-0a37-4c28-a603-fcd19508196a"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t2", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a0", "2"], "-", 
      SuperscriptBox["af", "2"], "-", 
      RowBox[{"4", " ", "aMax", " ", "jMax", " ", "t3"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox["t3", "2"]}], "-", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
      RowBox[{"2", " ", "jMax", " ", "vf"}]}], 
     RowBox[{"2", " ", "aMax", " ", "jMax"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820469808107897*^9, 3.8204698547852592`*^9}, {
   3.820469885371089*^9, 3.82046996780054*^9}, 3.8204699993460207`*^9, {
   3.820470101023305*^9, 3.8204702334585743`*^9}, 3.820470299336344*^9, {
   3.820470333532864*^9, 3.820470358630972*^9}, {3.82047043212789*^9, 
   3.8204704753207808`*^9}, 3.8204706260831137`*^9, {3.820477186652748*^9, 
   3.820477257028311*^9}, {3.820478648120041*^9, 3.820478664517067*^9}, {
   3.8204794722087097`*^9, 3.820479492325042*^9}, {3.820479721136821*^9, 
   3.820479773670662*^9}},
 CellLabel->
  "Out[1614]=",ExpressionUUID->"70f967be-3b0e-42d6-b07b-5d0c463699fc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"t5r", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "]"}], "/.", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", "t"}], "}"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", "tmp", "]"}], ",", "CForm"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.82047949564819*^9, 3.8204795441918573`*^9}, {
  3.820479776683545*^9, 
  3.820479822458334*^9}},ExpressionUUID->"ba86318c-49c6-475e-8175-\
23998c1d35c0"],

Cell[BoxData[
 FractionBox[
  RowBox[{"af", "-", "aMax", "+", 
   RowBox[{"jMax", " ", "t3"}]}], "jMax"]], "Output",
 CellChangeTimes->{{3.820479496002727*^9, 3.8204795449724092`*^9}, {
  3.820479777017172*^9, 3.820479808185134*^9}},
 CellLabel->
  "Out[1622]=",ExpressionUUID->"d47918f5-d1be-4a71-b5a6-ecb86447e980"],

Cell[BoxData["\<\"(af - aMax + jMax*t3)/jMax\"\>"], "Output",
 CellChangeTimes->{{3.820479496002727*^9, 3.8204795449724092`*^9}, {
  3.820479777017172*^9, 3.820479808190071*^9}},
 CellLabel->
  "Out[1623]=",ExpressionUUID->"fb288fdc-c395-407c-abb8-789580173713"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tRoot", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"t3r", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootFunction", "=", 
   RowBox[{"tmpResult", "[", 
    RowBox[{"[", 
     RowBox[{"tRoot", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Last", "[", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "]"}]], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820470613518242*^9, 3.820470660295394*^9}, {
  3.8204795673292847`*^9, 3.820479585663599*^9}, {3.82047983025165*^9, 
  3.8204798546097918`*^9}},
 CellLabel->
  "In[1655]:=",ExpressionUUID->"8661a96e-a382-4a1f-9033-993cef60d8c3"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"12", " ", 
    SuperscriptBox["jMax", "4"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SuperscriptBox["a0", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["af", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a0", "3"], " ", "aMax"}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["af", "3"], " ", "aMax"}], "-", 
    RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", "v0"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a0", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "+", 
    RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", "vf"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["af", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
    RowBox[{"12", " ", "jMax", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{"p0", "-", "pf"}], ")"}]}], "+", 
       RowBox[{
        SuperscriptBox["aMax", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"v0", "-", "vf"}], ")"}]}], "+", 
       RowBox[{"jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["v0", "2"]}], "+", 
          SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.82047061428708*^9, 3.820470660649027*^9}, {
  3.820479566024355*^9, 3.8204795859232683`*^9}, {3.82047983069186*^9, 
  3.8204798548666077`*^9}},
 CellLabel->
  "Out[1658]=",ExpressionUUID->"26f01fc3-d112-4df2-a15e-79678a1bc775"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"t5r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a5", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], ")"}], "\[Equal]", 
     "aMax"}], ",", "t5"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t7r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a7", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", "t5r"}], ")"}], 
     "\[Equal]", "af"}], ",", "t7"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t6r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"v7", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t2", "\[Rule]", "0"}], ",", 
           RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
        RowBox[{"t5r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "vf"}], ",", 
    "t6"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t1r", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"p7", "/.", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"t2", "\[Rule]", "0"}], ",", 
             RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
          RowBox[{"t5r", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
         RowBox[{"t7r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t6r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "pf"}], ",", 
     "t1"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.820472981360763*^9, 3.8204730017906857`*^9}, {
  3.820473052122456*^9, 3.8204730760968523`*^9}},
 CellLabel->
  "In[1667]:=",ExpressionUUID->"d57e959b-b7e7-4c01-a8fa-026edffa41d9"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t5", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a0"}], "+", "aMax", "-", 
      RowBox[{"jMax", " ", "t1"}], "+", 
      RowBox[{"jMax", " ", "t3"}]}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820472964697912*^9, 3.820473008477085*^9}, {
   3.8204730525130043`*^9, 3.820473076525063*^9}, 3.820473210346684*^9, 
   3.8204804775964947`*^9},
 CellLabel->
  "Out[1667]=",ExpressionUUID->"b11919c9-3144-4341-aba1-0b1d8be41a19"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t7", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "af"}], "+", "aMax"}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820472964697912*^9, 3.820473008477085*^9}, {
   3.8204730525130043`*^9, 3.820473076525063*^9}, 3.820473210346684*^9, 
   3.820480477600416*^9},
 CellLabel->
  "Out[1668]=",ExpressionUUID->"1c12974d-0498-476d-927d-13b39c32b6c2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t6", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a0", "2"], "+", 
      SuperscriptBox["af", "2"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["aMax", "2"]}], "-", 
      RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["jMax", "2"], " ", "t1", " ", "t3"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox["t3", "2"]}], "-", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
      RowBox[{"2", " ", "jMax", " ", "vf"}]}], 
     RowBox[{"2", " ", "aMax", " ", "jMax"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820472964697912*^9, 3.820473008477085*^9}, {
   3.8204730525130043`*^9, 3.820473076525063*^9}, 3.820473210346684*^9, 
   3.820480477604775*^9},
 CellLabel->
  "Out[1669]=",ExpressionUUID->"f685fef8-e488-40f3-869c-d77499e633dc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "tAll", ",", "t1", ",", "t3", ",", "t5", ",", "t6", ",", "t7"}], 
        "}"}], "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
      RowBox[{"t5r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t7r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"t6r", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"t1r", "[", 
    RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p0", "\[Rule]", 
     RowBox[{"-", "2.78419"}]}], ",", 
    RowBox[{"v0", "\[Rule]", "0.218867"}], ",", 
    RowBox[{"a0", "\[Rule]", 
     RowBox[{"-", "0.0315753"}]}], ",", 
    RowBox[{"pf", "\[Rule]", 
     RowBox[{"-", "2.61554"}]}], ",", 
    RowBox[{"vf", "\[Rule]", "0.703079"}], ",", 
    RowBox[{"af", "\[Rule]", "1.81837"}], ",", 
    RowBox[{"vMax", "\[Rule]", "9.79655"}], ",", 
    RowBox[{"aMax", "\[Rule]", "2.38929"}], ",", 
    RowBox[{"jMax", "\[Rule]", "11.0884"}], ",", 
    RowBox[{"t3", "\[Rule]", "0.08184"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.820480428913846*^9, 3.820480429840912*^9}, {
  3.820480479652309*^9, 3.820480490978854*^9}, {3.820480533524412*^9, 
  3.820480667601686*^9}, {3.820480791868555*^9, 3.820480795155054*^9}},
 CellLabel->
  "In[1710]:=",ExpressionUUID->"c031ee14-cf99-44c4-b969-5d49c2e072bf"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.44168575365511054`", ",", "0.09828155312351912`", ",", "0.08184`", ",", 
   "0.20188257840131762`", ",", "0.008193580573331376`", ",", 
   "0.05148804155694237`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.820480430294427*^9, {3.820480482181438*^9, 3.820480491388426*^9}, {
   3.820480535020849*^9, 3.820480667899111*^9}, 3.820480795713722*^9},
 CellLabel->
  "Out[1710]=",ExpressionUUID->"83f74dbf-bf61-4c36-b5da-59096000bc76"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"t6r", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", "tmp", "]"}], ",", "CForm"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820473900870178*^9, 3.8204739063251762`*^9}, {
  3.820473974557673*^9, 3.820473992476828*^9}},
 CellLabel->
  "In[1070]:=",ExpressionUUID->"32f421af-9488-445c-9a56-fcc5c55c6037"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a0", "2"], "+", 
   SuperscriptBox["af", "2"], "-", 
   RowBox[{"2", " ", 
    SuperscriptBox["aMax", "2"]}], "-", 
   RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["jMax", "2"], " ", "t1", " ", "t3"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["jMax", "2"], " ", 
    SuperscriptBox["t3", "2"]}], "-", 
   RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
   RowBox[{"2", " ", "jMax", " ", "vf"}]}], 
  RowBox[{"2", " ", "aMax", " ", "jMax"}]]], "Output",
 CellChangeTimes->{{3.820473902144046*^9, 3.820473907217226*^9}, {
   3.820473975017323*^9, 3.8204739928606358`*^9}, 3.8204741134910316`*^9},
 CellLabel->
  "Out[1070]=",ExpressionUUID->"e9690900-44cb-4a97-85a3-7c8e1662421c"],

Cell[BoxData["\<\"(Power(a0,2) + Power(af,2) - 2*Power(aMax,2) - 4*a0*jMax*t3 \
- 4*Power(jMax,2)*t1*t3 + 2*Power(jMax,2)*Power(t3,2) - 2*jMax*v0 + \
2*jMax*vf)/(2.*aMax*jMax)\"\>"], "Output",
 CellChangeTimes->{{3.820473902144046*^9, 3.820473907217226*^9}, {
   3.820473975017323*^9, 3.8204739928606358`*^9}, 3.820474113494688*^9},
 CellLabel->
  "Out[1071]=",ExpressionUUID->"846e2b30-d6d0-4e57-b203-3ccfaa6c2c9f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"t3r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"t6r", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "/.", 
       RowBox[{"t1r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "0"}], ",", "t3",
     ",", 
    RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8204742352499638`*^9, 3.820474277076106*^9}},
 CellLabel->
  "In[1080]:=",ExpressionUUID->"98e5f169-5f1d-47e0-b55e-2ae66f4200cb"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["aMax", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["a0", "3"]}], 
              SuperscriptBox["jMax", "3"]]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "2"], " ", "aMax"}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "a0", " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"96", " ", "aMax", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"48", " ", "vf"}], "jMax"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["aMax", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["a0", "3"]}], 
              SuperscriptBox["jMax", "3"]]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "2"], " ", "aMax"}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "a0", " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"96", " ", "aMax", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"48", " ", "vf"}], "jMax"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["aMax", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["a0", "3"]}], 
              SuperscriptBox["jMax", "3"]]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "2"], " ", "aMax"}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "a0", " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"96", " ", "aMax", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"48", " ", "vf"}], "jMax"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["a0", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"3", " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["aMax", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["aMax", "4"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["a0", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", 
           SuperscriptBox["aMax", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"24", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"12", " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FractionBox[
              RowBox[{"16", " ", 
               SuperscriptBox["a0", "3"]}], 
              SuperscriptBox["jMax", "3"]]}], "+", 
            FractionBox[
             RowBox[{"16", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "2"], " ", "aMax"}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", "a0", " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"96", " ", "aMax", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["a0", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"24", " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["aMax", "2"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"48", " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"48", " ", "vf"}], "jMax"]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "-", 
         RowBox[{"12", " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.820474233636759*^9, 3.820474277845888*^9}},
 CellLabel->
  "Out[1080]=",ExpressionUUID->"8ee6fb37-c85f-48c4-aa14-1794c1a3c7c6"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[Sqrt]", 
  RowBox[{"(", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      SuperscriptBox["aMax", "2"], " ", "jMax"}]], 
    RowBox[{"t3", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "3"}], " ", 
        SuperscriptBox["a0", "4"], " ", "aMax"}], "+", 
       RowBox[{"3", " ", 
        SuperscriptBox["af", "4"], " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["a0", "3"], " ", "aMax", " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
       RowBox[{"8", " ", 
        SuperscriptBox["af", "3"], " ", "aMax", " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
       RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "v0"}], "-", 
       RowBox[{"6", " ", 
        SuperscriptBox["a0", "2"], " ", "aMax", " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["aMax", "2"], "+", 
          RowBox[{"4", " ", "aMax", " ", "jMax", " ", "t3"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["jMax", "2"], " ", 
           SuperscriptBox["t3", "2"]}], "-", 
          RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "-", 
       RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "vf"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["af", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"aMax", "+", 
          RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox["aMax", "2"], "+", 
          RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
       RowBox[{"6", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SuperscriptBox["aMax", "4"], " ", "t3"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["jMax", "2"], " ", "t3", " ", 
           SuperscriptBox["vf", "2"]}], "+", 
          RowBox[{"2", " ", 
           SuperscriptBox["aMax", "3"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", " ", "jMax", " ", 
              SuperscriptBox["t3", "2"]}], "+", "v0", "+", "vf"}], ")"}]}], 
          "+", 
          RowBox[{
           SuperscriptBox["aMax", "2"], " ", "jMax", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "p0"}], "-", 
             RowBox[{"4", " ", "pf"}], "+", 
             RowBox[{"5", " ", "jMax", " ", 
              SuperscriptBox["t3", "3"]}], "+", 
             RowBox[{"8", " ", "t3", " ", "v0"}], "+", 
             RowBox[{"4", " ", "t3", " ", "vf"}]}], ")"}]}], "+", 
          RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SuperscriptBox["jMax", "2"], " ", 
              SuperscriptBox["t3", "4"]}], "-", 
             SuperscriptBox["v0", "2"], "+", 
             RowBox[{"4", " ", "jMax", " ", "t3", " ", 
              RowBox[{"(", 
               RowBox[{"p0", "-", "pf", "+", 
                RowBox[{"t3", " ", "v0"}]}], ")"}]}], "+", 
             SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Input",ExpressionUUID->"6e919ab8-7fe2-47c6-90c0-23d9f010233f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"t6", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
       RowBox[{"t5r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"t7r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t6r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"t1r", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "]"}]], "Input",
 CellChangeTimes->{{3.820473711625061*^9, 3.820473714480792*^9}, {
  3.8204809576139183`*^9, 3.820480974388446*^9}},
 CellLabel->
  "In[1716]:=",ExpressionUUID->"48585b25-f917-4a21-8579-f955faf3196d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"3", " ", 
     SuperscriptBox["a0", "2"], " ", "aMax"}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["af", "2"], " ", "aMax"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["aMax", "3"]}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["af", "2"], " ", "jMax", " ", "t3"}], "-", 
    RowBox[{"18", " ", 
     SuperscriptBox["aMax", "2"], " ", "jMax", " ", "t3"}], "-", 
    RowBox[{"12", " ", "aMax", " ", 
     SuperscriptBox["jMax", "2"], " ", 
     SuperscriptBox["t3", "2"]}], "-", 
    RowBox[{"6", " ", "aMax", " ", "jMax", " ", "v0"}], "+", 
    RowBox[{"6", " ", "aMax", " ", "jMax", " ", "vf"}], "+", 
    RowBox[{"12", " ", 
     SuperscriptBox["jMax", "2"], " ", "t3", " ", "vf"}], "-", 
    RowBox[{
     SqrtBox["6"], " ", "aMax", " ", "jMax", " ", 
     RowBox[{"\[Sqrt]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", 
         RowBox[{
          SuperscriptBox["aMax", "2"], " ", "jMax"}]], 
        RowBox[{"t3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "3"}], " ", 
            SuperscriptBox["a0", "4"], " ", "aMax"}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["af", "4"], " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["a0", "3"], " ", "aMax", " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["af", "3"], " ", "aMax", " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
           RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "v0"}], 
           "-", 
           RowBox[{"6", " ", 
            SuperscriptBox["a0", "2"], " ", "aMax", " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["aMax", "2"], "+", 
              RowBox[{"4", " ", "aMax", " ", "jMax", " ", "t3"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["jMax", "2"], " ", 
               SuperscriptBox["t3", "2"]}], "-", 
              RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "-", 
           RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "vf"}], 
           "+", 
           RowBox[{"6", " ", 
            SuperscriptBox["af", "2"], " ", 
            RowBox[{"(", 
             RowBox[{"aMax", "+", 
              RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", 
            RowBox[{"(", 
             RowBox[{
              SuperscriptBox["aMax", "2"], "+", 
              RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
           RowBox[{"6", " ", "jMax", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["aMax", "4"], " ", "t3"}], "+", 
              RowBox[{"4", " ", 
               SuperscriptBox["jMax", "2"], " ", "t3", " ", 
               SuperscriptBox["vf", "2"]}], "+", 
              RowBox[{"2", " ", 
               SuperscriptBox["aMax", "3"], " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"2", " ", "jMax", " ", 
                  SuperscriptBox["t3", "2"]}], "+", "v0", "+", "vf"}], 
                ")"}]}], "+", 
              RowBox[{
               SuperscriptBox["aMax", "2"], " ", "jMax", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"4", " ", "p0"}], "-", 
                 RowBox[{"4", " ", "pf"}], "+", 
                 RowBox[{"5", " ", "jMax", " ", 
                  SuperscriptBox["t3", "3"]}], "+", 
                 RowBox[{"8", " ", "t3", " ", "v0"}], "+", 
                 RowBox[{"4", " ", "t3", " ", "vf"}]}], ")"}]}], "+", 
              RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  SuperscriptBox["jMax", "2"], " ", 
                  SuperscriptBox["t3", "4"]}], "-", 
                 SuperscriptBox["v0", "2"], "+", 
                 RowBox[{"4", " ", "jMax", " ", "t3", " ", 
                  RowBox[{"(", 
                   RowBox[{"p0", "-", "pf", "+", 
                    RowBox[{"t3", " ", "v0"}]}], ")"}]}], "+", 
                 SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}]}],
        ")"}]}]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"6", " ", "aMax", " ", "jMax", " ", 
    RowBox[{"(", 
     RowBox[{"aMax", "+", 
      RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.820473585804414*^9, {3.8204737127364397`*^9, 3.8204737147369204`*^9}, {
   3.820480955037435*^9, 3.82048097487825*^9}},
 CellLabel->
  "Out[1716]=",ExpressionUUID->"86b769ae-d0e9-46d5-bec7-0ff43a85c15b"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"tAll", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t2", "\[Rule]", "0"}], ",", 
           RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
        RowBox[{"t5r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"t6r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t1r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p0", "\[Rule]", "2.00552"}], ",", 
    RowBox[{"v0", "\[Rule]", "0.117313"}], ",", 
    RowBox[{"a0", "\[Rule]", 
     RowBox[{"-", "0.257548"}]}], ",", 
    RowBox[{"pf", "\[Rule]", "0.753794"}], ",", 
    RowBox[{"vf", "\[Rule]", 
     RowBox[{"-", "1.85382"}]}], ",", 
    RowBox[{"af", "\[Rule]", 
     RowBox[{"-", "0.3"}]}], ",", 
    RowBox[{"vMax", "\[Rule]", 
     RowBox[{"-", "3.5414"}]}], ",", 
    RowBox[{"aMax", "\[Rule]", 
     RowBox[{"-", "2.50139"}]}], ",", 
    RowBox[{"jMax", "\[Rule]", 
     RowBox[{"-", "4.74624"}]}], ",", 
    RowBox[{"t3", "\[Rule]", "0.3044258"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.820473078750752*^9, 3.820473172630065*^9}, {
   3.8204732135474052`*^9, 3.820473451110177*^9}, {3.820473508587474*^9, 
   3.820473571213512*^9}, 3.820473633427541*^9, {3.820473845194648*^9, 
   3.820473856657031*^9}, {3.820474169214101*^9, 3.820474171935603*^9}},
 CellLabel->
  "In[1726]:=",ExpressionUUID->"f0e719fb-1f43-4b7b-ab13-e0030e29f802"],

Cell[BoxData["1.4821339960017283`"], "Output",
 CellChangeTimes->{{3.82047333272334*^9, 3.820473451587966*^9}, {
   3.820473509628545*^9, 3.820473571549449*^9}, 3.820473634210655*^9, {
   3.820473845572859*^9, 3.820473857237887*^9}, {3.820474169732028*^9, 
   3.820474172317548*^9}, 3.820489463914298*^9},
 CellLabel->
  "Out[1726]=",ExpressionUUID->"39d1a936-3d0f-4fbf-8715-c719389e4289"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"t3r", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SuperscriptBox["aMax", "2"], " ", "jMax"}]], " ", "t3", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "3"}], " ", 
          SuperscriptBox["a0", "4"], " ", "aMax"}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["af", "4"], " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SuperscriptBox["a0", "3"], " ", "aMax", " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
         RowBox[{"8", " ", 
          SuperscriptBox["af", "3"], " ", "aMax", " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}]}], "-", 
         RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "v0"}], "-", 
         
         RowBox[{"6", " ", 
          SuperscriptBox["a0", "2"], " ", "aMax", " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["aMax", "2"], "+", 
            RowBox[{"4", " ", "aMax", " ", "jMax", " ", "t3"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["jMax", "2"], " ", 
             SuperscriptBox["t3", "2"]}], "-", 
            RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "-", 
         RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", "vf"}], "+", 
         
         RowBox[{"6", " ", 
          SuperscriptBox["af", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"aMax", "+", 
            RowBox[{"2", " ", "jMax", " ", "t3"}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            SuperscriptBox["aMax", "2"], "+", 
            RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
         RowBox[{"6", " ", "jMax", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SuperscriptBox["aMax", "4"], " ", "t3"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["jMax", "2"], " ", "t3", " ", 
             SuperscriptBox["vf", "2"]}], "+", 
            RowBox[{"2", " ", 
             SuperscriptBox["aMax", "3"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", " ", "jMax", " ", 
                SuperscriptBox["t3", "2"]}], "+", "v0", "+", "vf"}], ")"}]}], 
            "+", 
            RowBox[{
             SuperscriptBox["aMax", "2"], " ", "jMax", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"4", " ", "p0"}], "-", 
               RowBox[{"4", " ", "pf"}], "+", 
               RowBox[{"5", " ", "jMax", " ", 
                SuperscriptBox["t3", "3"]}], "+", 
               RowBox[{"8", " ", "t3", " ", "v0"}], "+", 
               RowBox[{"4", " ", "t3", " ", "vf"}]}], ")"}]}], "+", 
            RowBox[{"2", " ", "aMax", " ", "jMax", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SuperscriptBox["jMax", "2"], " ", 
                SuperscriptBox["t3", "4"]}], "-", 
               SuperscriptBox["v0", "2"], "+", 
               RowBox[{"4", " ", "jMax", " ", "t3", " ", 
                RowBox[{"(", 
                 RowBox[{"p0", "-", "pf", "+", 
                  RowBox[{"t3", " ", "v0"}]}], ")"}]}], "+", 
               SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
      "\[Equal]", "0"}], ",", "t3", ",", 
     RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.820473613615443*^9, 3.820473672689103*^9}, {
  3.820474010646545*^9, 3.820474014572475*^9}},
 CellLabel->
  "In[1033]:=",ExpressionUUID->"deec1acf-7f7f-498a-a271-e1d2a4884e2c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"t5r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a5", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], ")"}], "\[Equal]", 
     "aMax"}], ",", "t5"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t7r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a7", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", "t5r"}], ")"}], 
     "\[Equal]", "af"}], ",", "t7"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t6r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"v7", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t2", "\[Rule]", "0"}], ",", 
           RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
        RowBox[{"t5r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "vf"}], ",", 
    "t6"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t1d", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"t1", "+", "t3", "+", "t5", "+", "t6", "+", "t7"}], 
              ")"}], "/.", 
             RowBox[{"t7r", "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
            RowBox[{"t5r", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
           RowBox[{"t6r", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/.", 
         RowBox[{"{", 
          RowBox[{"t1", "\[Rule]", 
           RowBox[{"t1", "[", "t3", "]"}]}], "}"}]}], ",", "t3"}], "]"}], 
      "]"}], "\[Equal]", "0"}], ",", 
    RowBox[{"t1", "[", "t3", "]"}], ",", "t3"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t3r", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{"p7", "/.", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"t2", "\[Rule]", "0"}], ",", 
              RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
           RowBox[{"t5r", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
          RowBox[{"t7r", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
         RowBox[{"t6r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"{", 
         RowBox[{"t1", "\[Rule]", 
          RowBox[{"t1d", "[", 
           RowBox[{"[", 
            RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "}"}]}], ")"}],
       "\[Equal]", "pf"}], ",", "t3", ",", 
     RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.820328385684849*^9, 3.820328491820876*^9}, {
  3.820328532213419*^9, 3.8203285782527523`*^9}, {3.820328729886532*^9, 
  3.820328734855196*^9}, {3.820410678105442*^9, 3.8204106911523943`*^9}, {
  3.820410841821311*^9, 3.820410902942539*^9}, {3.820411051780616*^9, 
  3.82041106879978*^9}, {3.8204115272537537`*^9, 3.820411569036038*^9}, {
  3.820413643850143*^9, 3.820413676200116*^9}, {3.820472516336574*^9, 
  3.820472517302066*^9}},
 CellLabel->
  "In[1661]:=",ExpressionUUID->"76c16481-de84-4e2e-a943-429ec44acad1"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t5", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "a0"}], "+", "aMax", "-", 
      RowBox[{"jMax", " ", "t1"}], "+", 
      RowBox[{"jMax", " ", "t3"}]}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.82032839370313*^9, 3.820328418242559*^9}, {
   3.82032846599503*^9, 3.820328492264715*^9}, {3.8203285329447813`*^9, 
   3.820328537485448*^9}, {3.820328567916113*^9, 3.820328579066002*^9}, 
   3.8203286196111507`*^9, 3.82032869522841*^9, {3.820328730797233*^9, 
   3.8203287354905577`*^9}, {3.820410394308826*^9, 3.820410403083768*^9}, {
   3.820410678771249*^9, 3.820410691616139*^9}, {3.820410842755965*^9, 
   3.820410903296626*^9}, {3.820411055065836*^9, 3.820411069310123*^9}, 
   3.820411453020125*^9, {3.820411527574298*^9, 3.820411569445904*^9}, {
   3.820413644277446*^9, 3.820413676581644*^9}, {3.820471321426074*^9, 
   3.820471323404182*^9}, 3.820472517882669*^9, 3.8204804079769993`*^9},
 CellLabel->
  "Out[1661]=",ExpressionUUID->"4675b0ed-5411-4e27-b784-ece8f684f923"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t7", "\[Rule]", 
    FractionBox[
     RowBox[{
      RowBox[{"-", "af"}], "+", "aMax"}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.82032839370313*^9, 3.820328418242559*^9}, {
   3.82032846599503*^9, 3.820328492264715*^9}, {3.8203285329447813`*^9, 
   3.820328537485448*^9}, {3.820328567916113*^9, 3.820328579066002*^9}, 
   3.8203286196111507`*^9, 3.82032869522841*^9, {3.820328730797233*^9, 
   3.8203287354905577`*^9}, {3.820410394308826*^9, 3.820410403083768*^9}, {
   3.820410678771249*^9, 3.820410691616139*^9}, {3.820410842755965*^9, 
   3.820410903296626*^9}, {3.820411055065836*^9, 3.820411069310123*^9}, 
   3.820411453020125*^9, {3.820411527574298*^9, 3.820411569445904*^9}, {
   3.820413644277446*^9, 3.820413676581644*^9}, {3.820471321426074*^9, 
   3.820471323404182*^9}, 3.820472517882669*^9, 3.820480407983542*^9},
 CellLabel->
  "Out[1662]=",ExpressionUUID->"eb011791-010b-4a86-a2e5-3017cc81a2b0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t6", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a0", "2"], "+", 
      SuperscriptBox["af", "2"], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["aMax", "2"]}], "-", 
      RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
      RowBox[{"4", " ", 
       SuperscriptBox["jMax", "2"], " ", "t1", " ", "t3"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox["t3", "2"]}], "-", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
      RowBox[{"2", " ", "jMax", " ", "vf"}]}], 
     RowBox[{"2", " ", "aMax", " ", "jMax"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.82032839370313*^9, 3.820328418242559*^9}, {
   3.82032846599503*^9, 3.820328492264715*^9}, {3.8203285329447813`*^9, 
   3.820328537485448*^9}, {3.820328567916113*^9, 3.820328579066002*^9}, 
   3.8203286196111507`*^9, 3.82032869522841*^9, {3.820328730797233*^9, 
   3.8203287354905577`*^9}, {3.820410394308826*^9, 3.820410403083768*^9}, {
   3.820410678771249*^9, 3.820410691616139*^9}, {3.820410842755965*^9, 
   3.820410903296626*^9}, {3.820411055065836*^9, 3.820411069310123*^9}, 
   3.820411453020125*^9, {3.820411527574298*^9, 3.820411569445904*^9}, {
   3.820413644277446*^9, 3.820413676581644*^9}, {3.820471321426074*^9, 
   3.820471323404182*^9}, 3.820472517882669*^9, 3.820480407985921*^9},
 CellLabel->
  "Out[1663]=",ExpressionUUID->"68ed0252-2b59-470b-8053-401273051ec8"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t1", "[", "t3", "]"}], "\[Rule]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "a0"}], " ", "t3"}], "+", 
       RowBox[{"aMax", " ", "t3"}], "+", 
       FractionBox[
        RowBox[{"jMax", " ", 
         SuperscriptBox["t3", "2"]}], "2"]}], 
      RowBox[{"jMax", " ", "t3"}]], "+", 
     FractionBox[
      TemplateBox[{"1"},
       "C"], "t3"]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.82032839370313*^9, 3.820328418242559*^9}, {
   3.82032846599503*^9, 3.820328492264715*^9}, {3.8203285329447813`*^9, 
   3.820328537485448*^9}, {3.820328567916113*^9, 3.820328579066002*^9}, 
   3.8203286196111507`*^9, 3.82032869522841*^9, {3.820328730797233*^9, 
   3.8203287354905577`*^9}, {3.820410394308826*^9, 3.820410403083768*^9}, {
   3.820410678771249*^9, 3.820410691616139*^9}, {3.820410842755965*^9, 
   3.820410903296626*^9}, {3.820411055065836*^9, 3.820411069310123*^9}, 
   3.820411453020125*^9, {3.820411527574298*^9, 3.820411569445904*^9}, {
   3.820413644277446*^9, 3.820413676581644*^9}, {3.820471321426074*^9, 
   3.820471323404182*^9}, 3.820472517882669*^9, 3.820480408021639*^9},
 CellLabel->
  "Out[1664]=",ExpressionUUID->"be5f1406-07e7-49d2-b86b-8e78cb1713a9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"t1", "+", "t3", "+", "t5", "+", "t6", "+", "t7"}], ")"}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"t5r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t6r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/.", 
   RowBox[{"{", 
    RowBox[{"t1", "\[Rule]", 
     RowBox[{"t1d", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->
  "In[818]:=",ExpressionUUID->"861d34e3-2181-41b8-9a73-9af562bed505"],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["a0", "2"], "+", 
   SuperscriptBox["af", "2"], "-", 
   RowBox[{"2", " ", "a0", " ", "aMax"}], "-", 
   RowBox[{"2", " ", "af", " ", "aMax"}], "+", 
   RowBox[{"2", " ", 
    SuperscriptBox["aMax", "2"]}], "-", 
   RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
   RowBox[{"2", " ", "jMax", " ", "vf"}], "-", 
   RowBox[{"4", " ", 
    SuperscriptBox["jMax", "2"], " ", 
    TemplateBox[{"1"},
     "C"]}]}], 
  RowBox[{"2", " ", "aMax", " ", "jMax"}]]], "Output",
 CellChangeTimes->{3.8204133240528812`*^9, 3.820469371353983*^9, 
  3.820471330811005*^9},
 CellLabel->
  "Out[818]=",ExpressionUUID->"a0048a6d-ac5f-4c36-a7f8-8a7117a4ed35"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t1", "+", "t3", "+", "t5", "+", "t6", "+", "t7"}], ")"}], 
          "/.", 
          RowBox[{"t7r", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
         RowBox[{"t5r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t6r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/.", 
      RowBox[{"{", 
       RowBox[{"t1", "\[Rule]", 
        RowBox[{"t1d", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "}"}]}], "]"}], 
    ",", 
    TemplateBox[{"1"},
     "C"]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{3.820413297501082*^9},
 CellLabel->
  "In[430]:=",ExpressionUUID->"8ce61ef8-3d6a-4ec6-b070-7abcd1cfb2c8"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"2", " ", "jMax"}], "aMax"]}]], "Output",
 CellChangeTimes->{3.820413298115674*^9},
 CellLabel->
  "Out[430]=",ExpressionUUID->"fdecf7ce-a690-4d2a-90bb-ba63fe9a6577"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"t1d", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", "tmp", "]"}], ",", "CForm"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820411594302718*^9, 3.820411600265356*^9}, {
  3.8204116339142923`*^9, 3.8204117055296087`*^9}, {3.820412430326427*^9, 
  3.820412430943693*^9}, {3.8204133951950502`*^9, 3.820413442420022*^9}, {
  3.820413498076028*^9, 3.82041349913265*^9}, {3.820413724873139*^9, 
  3.820413746325324*^9}, {3.820472390348815*^9, 3.8204724558555603`*^9}},
 CellLabel->
  "In[840]:=",ExpressionUUID->"2dc0fa63-a868-4783-87f2-49c1dcb40d82"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["a0", "jMax"]}], "+", 
  FractionBox["aMax", "jMax"], "+", 
  FractionBox["t3", "2"], "+", 
  FractionBox[
   TemplateBox[{"1"},
    "C"], "t3"]}]], "Output",
 CellChangeTimes->{
  3.8204116006288023`*^9, {3.8204116343600283`*^9, 3.8204117060074673`*^9}, 
   3.820412431410157*^9, {3.820413395547113*^9, 3.820413442946476*^9}, 
   3.820413499970809*^9, {3.820413726305271*^9, 3.820413746802314*^9}, {
   3.820472385486072*^9, 3.820472456838818*^9}},
 CellLabel->
  "Out[840]=",ExpressionUUID->"2488aad7-c0fe-4f3c-b9a0-6bceaeb7422d"],

Cell[BoxData["\<\"-(a0/jMax) + aMax/jMax + t3/2. + C(1)/t3\"\>"], "Output",
 CellChangeTimes->{
  3.8204116006288023`*^9, {3.8204116343600283`*^9, 3.8204117060074673`*^9}, 
   3.820412431410157*^9, {3.820413395547113*^9, 3.820413442946476*^9}, 
   3.820413499970809*^9, {3.820413726305271*^9, 3.820413746802314*^9}, {
   3.820472385486072*^9, 3.820472456842058*^9}},
 CellLabel->
  "Out[841]=",ExpressionUUID->"7d97b2e4-726d-4e74-9996-18de0eb3b62a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tRoot", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"t3r", "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootFunction", "=", 
   RowBox[{"tmpResult", "[", 
    RowBox[{"[", 
     RowBox[{"tRoot", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Last", "[", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "]"}]], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.8204112870913887`*^9, 3.820411353892598*^9}, {
  3.820411449371757*^9, 3.820411504100471*^9}, {3.820413626449093*^9, 
  3.8204136371917067`*^9}, {3.8204136819747753`*^9, 3.820413709817792*^9}, {
  3.820472530803228*^9, 3.8204725399476757`*^9}, {3.8204740215030518`*^9, 
  3.8204740441701117`*^9}, {3.820474320896206*^9, 3.82047434440598*^9}},
 CellLabel->
  "In[1111]:=",ExpressionUUID->"24c1c053-80c3-4a2c-88a6-6d4c95ef0728"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a0", "2"], "+", 
      SuperscriptBox["af", "2"], "-", 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["aMax", "2"], "+", 
         RowBox[{"jMax", " ", "v0"}], "-", 
         RowBox[{"jMax", " ", "vf"}]}], ")"}]}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["jMax", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.820411289155355*^9, 3.820411354444262*^9}, {
  3.8204114497026043`*^9, 3.820411504363306*^9}, {3.820413682722988*^9, 
  3.8204137101103077`*^9}, {3.820472522850286*^9, 3.8204725403208923`*^9}, {
  3.8204740218955936`*^9, 3.820474044456971*^9}, {3.820474321594151*^9, 
  3.8204743446840887`*^9}},
 CellLabel->
  "Out[1114]=",ExpressionUUID->"04df113e-12b6-4d82-83cc-fdc54fb34f30"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"p7", "-", "pf"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t2", "\[Rule]", "0"}], ",", 
            RowBox[{"t4", "\[Rule]", "0"}]}], "}"}]}], "/.", 
         RowBox[{"t5r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t7r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t6r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"{", 
       RowBox[{"t1", "\[Rule]", 
        RowBox[{"t1d", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "}"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{
       TemplateBox[{"1"},
        "C"], "\[Rule]", "0"}], "}"}]}], ")"}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"D", "[", 
      RowBox[{"tmp", ",", "t3"}], "]"}], "]"}], ",", "CForm"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820412120154948*^9, 3.820412147784712*^9}, {
  3.820412208591464*^9, 3.820412208871632*^9}, {3.8204122400789967`*^9, 
  3.820412290611835*^9}},
 CellLabel->
  "In[411]:=",ExpressionUUID->"f888d31a-1a5d-4b9f-8b3d-e8a2fbe1fedd"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"24", " ", "aMax", " ", 
    SuperscriptBox["jMax", "2"]}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "3"}], " ", 
     SuperscriptBox["a0", "4"]}], "+", 
    RowBox[{"3", " ", 
     SuperscriptBox["af", "4"]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["a0", "3"], " ", "aMax"}], "-", 
    RowBox[{"8", " ", 
     SuperscriptBox["af", "3"], " ", "aMax"}], "-", 
    RowBox[{"24", " ", "a0", " ", "aMax", " ", "jMax", " ", "v0"}], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox["a0", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "-", 
       RowBox[{"2", " ", "jMax", " ", "v0"}]}], ")"}]}], "-", 
    RowBox[{"24", " ", "af", " ", "aMax", " ", "jMax", " ", "vf"}], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox["af", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["aMax", "2"], "+", 
       RowBox[{"2", " ", "jMax", " ", "vf"}]}], ")"}]}], "+", 
    RowBox[{"6", " ", "jMax", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"aMax", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"4", " ", "p0"}], "-", 
          RowBox[{"4", " ", "pf"}], "+", 
          RowBox[{"jMax", " ", 
           SuperscriptBox["t3", "3"]}]}], ")"}]}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["aMax", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"v0", "+", "vf"}], ")"}]}], "+", 
       RowBox[{"2", " ", "jMax", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SuperscriptBox["v0", "2"]}], "+", 
          SuperscriptBox["vf", "2"]}], ")"}]}]}], ")"}]}]}], 
   ")"}]}]], "Output",
 CellChangeTimes->{{3.820412118240746*^9, 3.8204121482415257`*^9}, 
   3.820412209355076*^9, {3.8204122453115273`*^9, 3.820412291375392*^9}},
 CellLabel->
  "Out[411]=",ExpressionUUID->"526ec543-ec8c-4a9d-a247-0396d8fb630c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"t7r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a7", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}], ",", 
         RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], ")"}], "\[Equal]", "af"}],
     ",", "t7"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t3r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v7", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}], ",", 
          RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "vf"}], ",", 
    "t3"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t5r", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"p7", "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"t2", "\[Rule]", "0"}], ",", 
            RowBox[{"t4", "\[Rule]", "0"}], ",", 
            RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
         RowBox[{"t7r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t3r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "pf"}], ",", 
     "t5", ",", 
     RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.820474527826591*^9, 3.82047453154862*^9}, {
  3.8204745869449778`*^9, 3.8204746482659073`*^9}, {3.820474690083364*^9, 
  3.8204746969904337`*^9}, {3.820475129998219*^9, 3.8204751302241096`*^9}, {
  3.8204757828588877`*^9, 3.820475786665144*^9}},
 CellLabel->
  "In[1277]:=",ExpressionUUID->"c27c1a53-75cf-42e0-b674-3a9ffb6a0dc3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t7", "\[Rule]", 
    FractionBox[
     RowBox[{"a0", "-", "af", "+", 
      RowBox[{"jMax", " ", "t1"}], "-", 
      RowBox[{"jMax", " ", "t3"}], "+", 
      RowBox[{"jMax", " ", "t5"}]}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820474522634281*^9, 3.8204745333435373`*^9}, {
  3.8204745893224087`*^9, 3.820474701939642*^9}, {3.820475122316135*^9, 
  3.8204751553347607`*^9}, {3.820475783082013*^9, 3.8204757902259407`*^9}},
 CellLabel->
  "Out[1277]=",ExpressionUUID->"bf93046e-0f49-4485-8b45-38c284e26597"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t3", "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a0", "2"], "-", 
      SuperscriptBox["af", "2"], "+", 
      RowBox[{"4", " ", "a0", " ", "jMax", " ", "t1"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox["t1", "2"]}], "+", 
      RowBox[{"4", " ", "a0", " ", "jMax", " ", "t5"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["jMax", "2"], " ", "t1", " ", "t5"}], "+", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox["t5", "2"]}], "+", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "-", 
      RowBox[{"2", " ", "jMax", " ", "vf"}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["jMax", "2"], " ", "t5"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.820474522634281*^9, 3.8204745333435373`*^9}, {
  3.8204745893224087`*^9, 3.820474701939642*^9}, {3.820475122316135*^9, 
  3.8204751553347607`*^9}, {3.820475783082013*^9, 3.820475790265771*^9}},
 CellLabel->
  "Out[1278]=",ExpressionUUID->"47c327cd-74ba-487d-a735-9271fe465116"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "tAll", ",", "t1", ",", "t3", ",", "t5", ",", "t7", ",", "a1"}], "}"}],
       "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"t2", "\[Rule]", "0"}], ",", 
        RowBox[{"t4", "\[Rule]", "0"}], ",", 
        RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
     RowBox[{"t7r", "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
    RowBox[{"t3r", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
   RowBox[{"t5r", "[", 
    RowBox[{"[", "3", "]"}], "]"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p0", "\[Rule]", "2.00552"}], ",", 
    RowBox[{"v0", "\[Rule]", "0.117313"}], ",", 
    RowBox[{"a0", "\[Rule]", 
     RowBox[{"-", "0.257548"}]}], ",", 
    RowBox[{"pf", "\[Rule]", "0.753794"}], ",", 
    RowBox[{"vf", "\[Rule]", 
     RowBox[{"-", "1.85382"}]}], ",", 
    RowBox[{"af", "\[Rule]", 
     RowBox[{"-", "0.3"}]}], ",", 
    RowBox[{"vMax", "\[Rule]", 
     RowBox[{"-", "3.5414"}]}], ",", 
    RowBox[{"aMax", "\[Rule]", 
     RowBox[{"-", "2.50139"}]}], ",", 
    RowBox[{"jMax", "\[Rule]", 
     RowBox[{"-", "4.74624"}]}], ",", 
    RowBox[{"t1", "\[Rule]", "0.472"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.820474739143957*^9, 3.8204747886307707`*^9}, {
   3.82047498270383*^9, 3.8204750705300503`*^9}, {3.820475176134354*^9, 
   3.820475314202861*^9}, {3.820475866843523*^9, 3.820475883819644*^9}, 
   3.820475929369732*^9, {3.8204768646527967`*^9, 3.820476892549211*^9}},
 CellLabel->
  "In[1294]:=",ExpressionUUID->"8ea1a1c1-e3f2-4db8-ab7f-3f808af06c72"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.4034226212114036`", ",", "0.472`", ",", "0.34055719346887703`", ",", 
   "0.23418348226158106`", ",", "0.3566819454809457`", ",", 
   RowBox[{"-", "2.49777328`"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8204747558575583`*^9, 3.82047478889423*^9}, 
   3.820474936120831*^9, {3.820474983184946*^9, 3.820475071006033*^9}, {
   3.8204751353353777`*^9, 3.8204753144223413`*^9}, {3.820475867594133*^9, 
   3.8204758841501303`*^9}, 3.820475929889303*^9, {3.820476865309894*^9, 
   3.820476892800696*^9}},
 CellLabel->
  "Out[1294]=",ExpressionUUID->"4c0b888b-aea4-4c4d-8da6-1ffc5f77f43f"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"t7", "/.", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"t2", "\[Rule]", "0"}], ",", 
           RowBox[{"t4", "\[Rule]", "0"}], ",", 
           RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
        RowBox[{"t7r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"t3r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"t5r", "[", 
       RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "\[Equal]", "0"}], ",", "t1", 
   ",", 
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.82047532249549*^9, 3.820475387350528*^9}},
 CellLabel->
  "In[1273]:=",ExpressionUUID->"d9b81e1b-a620-4b83-b247-576167e171a3"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t1", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          SuperscriptBox["a0", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "4"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["a0", "3"], " ", 
           SuperscriptBox["af", "3"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          SuperscriptBox["af", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "2"]}], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{"144", " ", "p0", " ", "pf"}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["pf", "2"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"48", " ", "a0", " ", 
           SuperscriptBox["af", "3"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["af", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "p0", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "pf", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "3"]}], "jMax"], "+", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["a0", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "af", " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["af", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "p0", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "pf", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["a0", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "af", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["af", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "2"], " ", "vf"}], "jMax"], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"72", " ", "v0", " ", 
           SuperscriptBox["vf", "2"]}], "jMax"], "-", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["vf", "3"]}], "jMax"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"12", " ", 
              SuperscriptBox["a0", "5"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "3"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"36", " ", "a0", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["a0", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["af", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"288", " ", "p0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "pf", " ", "v0"}], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["v0", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"144", " ", 
              SuperscriptBox["a0", "3"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"288", " ", "a0", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"288", " ", "af", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["vf", "2"]}], "jMax"]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"54", " ", 
              SuperscriptBox["a0", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"180", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"18", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"432", " ", "a0", " ", "p0"}], "+", 
            RowBox[{"432", " ", "a0", " ", "pf"}], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "2"], " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], "jMax"], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["v0", "2"]}], "+", 
            FractionBox[
             RowBox[{"360", " ", 
              SuperscriptBox["a0", "2"], " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"432", " ", "a0", " ", "af", " ", "vf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], "jMax"], "+", 
            RowBox[{"144", " ", "v0", " ", "vf"}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["vf", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "3"]}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "3"]}], "jMax"], "-", 
            RowBox[{"144", " ", "jMax", " ", "p0"}], "+", 
            RowBox[{"144", " ", "jMax", " ", "pf"}], "-", 
            RowBox[{"144", " ", "a0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "a0", " ", "vf"}], "-", 
            RowBox[{"144", " ", "af", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"36", " ", 
             SuperscriptBox["a0", "2"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["af", "2"]}], "-", 
            RowBox[{"72", " ", "jMax", " ", "v0"}], "+", 
            RowBox[{"72", " ", "jMax", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "1"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t1", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          SuperscriptBox["a0", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "4"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["a0", "3"], " ", 
           SuperscriptBox["af", "3"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          SuperscriptBox["af", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "2"]}], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{"144", " ", "p0", " ", "pf"}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["pf", "2"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"48", " ", "a0", " ", 
           SuperscriptBox["af", "3"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["af", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "p0", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "pf", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "3"]}], "jMax"], "+", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["a0", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "af", " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["af", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "p0", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "pf", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["a0", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "af", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["af", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "2"], " ", "vf"}], "jMax"], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"72", " ", "v0", " ", 
           SuperscriptBox["vf", "2"]}], "jMax"], "-", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["vf", "3"]}], "jMax"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"12", " ", 
              SuperscriptBox["a0", "5"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "3"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"36", " ", "a0", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["a0", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["af", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"288", " ", "p0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "pf", " ", "v0"}], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["v0", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"144", " ", 
              SuperscriptBox["a0", "3"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"288", " ", "a0", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"288", " ", "af", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["vf", "2"]}], "jMax"]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"54", " ", 
              SuperscriptBox["a0", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"180", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"18", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"432", " ", "a0", " ", "p0"}], "+", 
            RowBox[{"432", " ", "a0", " ", "pf"}], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "2"], " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], "jMax"], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["v0", "2"]}], "+", 
            FractionBox[
             RowBox[{"360", " ", 
              SuperscriptBox["a0", "2"], " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"432", " ", "a0", " ", "af", " ", "vf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], "jMax"], "+", 
            RowBox[{"144", " ", "v0", " ", "vf"}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["vf", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "3"]}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "3"]}], "jMax"], "-", 
            RowBox[{"144", " ", "jMax", " ", "p0"}], "+", 
            RowBox[{"144", " ", "jMax", " ", "pf"}], "-", 
            RowBox[{"144", " ", "a0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "a0", " ", "vf"}], "-", 
            RowBox[{"144", " ", "af", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"36", " ", 
             SuperscriptBox["a0", "2"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["af", "2"]}], "-", 
            RowBox[{"72", " ", "jMax", " ", "v0"}], "+", 
            RowBox[{"72", " ", "jMax", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "2"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t1", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          SuperscriptBox["a0", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "4"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["a0", "3"], " ", 
           SuperscriptBox["af", "3"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          SuperscriptBox["af", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "2"]}], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{"144", " ", "p0", " ", "pf"}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["pf", "2"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"48", " ", "a0", " ", 
           SuperscriptBox["af", "3"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["af", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "p0", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "pf", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "3"]}], "jMax"], "+", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["a0", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "af", " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["af", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "p0", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "pf", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["a0", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "af", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["af", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "2"], " ", "vf"}], "jMax"], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"72", " ", "v0", " ", 
           SuperscriptBox["vf", "2"]}], "jMax"], "-", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["vf", "3"]}], "jMax"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"12", " ", 
              SuperscriptBox["a0", "5"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "3"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"36", " ", "a0", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["a0", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["af", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"288", " ", "p0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "pf", " ", "v0"}], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["v0", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"144", " ", 
              SuperscriptBox["a0", "3"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"288", " ", "a0", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"288", " ", "af", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["vf", "2"]}], "jMax"]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"54", " ", 
              SuperscriptBox["a0", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"180", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"18", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"432", " ", "a0", " ", "p0"}], "+", 
            RowBox[{"432", " ", "a0", " ", "pf"}], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "2"], " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], "jMax"], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["v0", "2"]}], "+", 
            FractionBox[
             RowBox[{"360", " ", 
              SuperscriptBox["a0", "2"], " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"432", " ", "a0", " ", "af", " ", "vf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], "jMax"], "+", 
            RowBox[{"144", " ", "v0", " ", "vf"}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["vf", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "3"]}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "3"]}], "jMax"], "-", 
            RowBox[{"144", " ", "jMax", " ", "p0"}], "+", 
            RowBox[{"144", " ", "jMax", " ", "pf"}], "-", 
            RowBox[{"144", " ", "a0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "a0", " ", "vf"}], "-", 
            RowBox[{"144", " ", "af", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"36", " ", 
             SuperscriptBox["a0", "2"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["af", "2"]}], "-", 
            RowBox[{"72", " ", "jMax", " ", "v0"}], "+", 
            RowBox[{"72", " ", "jMax", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "3"}], "]"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t1", "\[Rule]", 
     RowBox[{"Root", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox[
          SuperscriptBox["a0", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "4"], " ", 
           SuperscriptBox["af", "2"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          RowBox[{"16", " ", 
           SuperscriptBox["a0", "3"], " ", 
           SuperscriptBox["af", "3"]}], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"9", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "4"]}], 
          SuperscriptBox["jMax", "4"]], "+", 
         FractionBox[
          SuperscriptBox["af", "6"], 
          SuperscriptBox["jMax", "4"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "p0"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["p0", "2"]}], "+", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["af", "3"], " ", "pf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         RowBox[{"144", " ", "p0", " ", "pf"}], "-", 
         RowBox[{"72", " ", 
          SuperscriptBox["pf", "2"]}], "+", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["a0", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"48", " ", "a0", " ", 
           SuperscriptBox["af", "3"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["af", "4"], " ", "v0"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "p0", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "pf", " ", "v0"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["v0", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "3"]}], "jMax"], "+", 
         FractionBox[
          RowBox[{"18", " ", 
           SuperscriptBox["a0", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"48", " ", 
           SuperscriptBox["a0", "3"], " ", "af", " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["af", "2"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"6", " ", 
           SuperscriptBox["af", "4"], " ", "vf"}], 
          SuperscriptBox["jMax", "3"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "p0", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"144", " ", "af", " ", "pf", " ", "vf"}], "jMax"], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["a0", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"144", " ", "a0", " ", "af", " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["af", "2"], " ", "v0", " ", "vf"}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["v0", "2"], " ", "vf"}], "jMax"], "-", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["a0", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "+", 
         FractionBox[
          RowBox[{"36", " ", 
           SuperscriptBox["af", "2"], " ", 
           SuperscriptBox["vf", "2"]}], 
          SuperscriptBox["jMax", "2"]], "-", 
         FractionBox[
          RowBox[{"72", " ", "v0", " ", 
           SuperscriptBox["vf", "2"]}], "jMax"], "-", 
         FractionBox[
          RowBox[{"72", " ", 
           SuperscriptBox["vf", "3"]}], "jMax"], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"12", " ", 
              SuperscriptBox["a0", "5"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "3"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "3"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"36", " ", "a0", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "3"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "p0"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "pf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["a0", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["af", "3"], " ", "v0"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"288", " ", "p0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "pf", " ", "v0"}], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["v0", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"144", " ", 
              SuperscriptBox["a0", "3"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"288", " ", 
              SuperscriptBox["a0", "2"], " ", "af", " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"288", " ", "a0", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"288", " ", "af", " ", "v0", " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["vf", "2"]}], "jMax"]}], ")"}], " ", "#1"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"54", " ", 
              SuperscriptBox["a0", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"180", " ", 
              SuperscriptBox["a0", "2"], " ", 
              SuperscriptBox["af", "2"]}], 
             SuperscriptBox["jMax", "2"]], "+", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "3"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            FractionBox[
             RowBox[{"18", " ", 
              SuperscriptBox["af", "4"]}], 
             SuperscriptBox["jMax", "2"]], "-", 
            RowBox[{"432", " ", "a0", " ", "p0"}], "+", 
            RowBox[{"432", " ", "a0", " ", "pf"}], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["a0", "2"], " ", "v0"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "v0"}], "jMax"], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["v0", "2"]}], "+", 
            FractionBox[
             RowBox[{"360", " ", 
              SuperscriptBox["a0", "2"], " ", "vf"}], "jMax"], "-", 
            FractionBox[
             RowBox[{"432", " ", "a0", " ", "af", " ", "vf"}], "jMax"], "+", 
            FractionBox[
             RowBox[{"72", " ", 
              SuperscriptBox["af", "2"], " ", "vf"}], "jMax"], "+", 
            RowBox[{"144", " ", "v0", " ", "vf"}], "-", 
            RowBox[{"72", " ", 
             SuperscriptBox["vf", "2"]}]}], ")"}], " ", 
          SuperscriptBox["#1", "2"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{"96", " ", 
              SuperscriptBox["a0", "3"]}], "jMax"], "-", 
            FractionBox[
             RowBox[{"144", " ", "a0", " ", 
              SuperscriptBox["af", "2"]}], "jMax"], "+", 
            FractionBox[
             RowBox[{"48", " ", 
              SuperscriptBox["af", "3"]}], "jMax"], "-", 
            RowBox[{"144", " ", "jMax", " ", "p0"}], "+", 
            RowBox[{"144", " ", "jMax", " ", "pf"}], "-", 
            RowBox[{"144", " ", "a0", " ", "v0"}], "+", 
            RowBox[{"288", " ", "a0", " ", "vf"}], "-", 
            RowBox[{"144", " ", "af", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "3"]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"36", " ", 
             SuperscriptBox["a0", "2"]}], "-", 
            RowBox[{"36", " ", 
             SuperscriptBox["af", "2"]}], "-", 
            RowBox[{"72", " ", "jMax", " ", "v0"}], "+", 
            RowBox[{"72", " ", "jMax", " ", "vf"}]}], ")"}], " ", 
          SuperscriptBox["#1", "4"]}]}], "&"}], ",", "4"}], "]"}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8204753231003*^9, 3.82047539274226*^9}},
 CellLabel->
  "Out[1273]=",ExpressionUUID->"4e0cc09a-c5bc-4f3f-8873-5f55f695a4a2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"t7r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"a7", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}], ",", 
         RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], ")"}], "\[Equal]", "af"}],
     ",", "t7"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t5r", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"v7", "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}], ",", 
          RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "\[Equal]", "vf"}], ",", 
    "t5"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"t1d", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Simplify", "[", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{"t1", "+", "t3", "+", "t5", "+", "t7"}], ")"}], "/.", 
            RowBox[{"t7r", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
           RowBox[{"t5r", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/.", 
         RowBox[{"{", 
          RowBox[{"t1", "\[Rule]", 
           RowBox[{"t1", "[", "t3", "]"}]}], "}"}]}], ",", "t3"}], "]"}], 
      "]"}], "\[Equal]", "0"}], ",", 
    RowBox[{"t1", "[", "t3", "]"}], ",", "t3"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.820148050395805*^9, 3.820148065954586*^9}, {
  3.820148217478517*^9, 3.820148217962729*^9}, {3.8203284480849323`*^9, 
  3.820328448285055*^9}, {3.820410835578142*^9, 3.820410835724801*^9}},
 CellLabel->
  "In[129]:=",ExpressionUUID->"a1407b25-8b1c-4678-950e-2905d2867987"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"t7", "\[Rule]", 
    FractionBox[
     RowBox[{"a0", "-", "af", "+", 
      RowBox[{"jMax", " ", "t1"}], "-", 
      RowBox[{"jMax", " ", "t3"}], "+", 
      RowBox[{"jMax", " ", "t5"}]}], "jMax"]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8201480664136763`*^9, 3.820148218603908*^9, 
  3.8201493225424232`*^9, 3.8203074896585093`*^9, 3.8203109114680367`*^9, 
  3.8203271557247353`*^9, 3.820328449198423*^9, 3.8204108362582893`*^9},
 CellLabel->
  "Out[129]=",ExpressionUUID->"950962bc-7fcf-4070-a72d-ac21f7ef17d6"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t5", "\[Rule]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "jMax"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a0"}], "-", 
        RowBox[{"2", " ", "jMax", " ", "t1"}], "+", 
        RowBox[{"2", " ", "jMax", " ", "t3"}], "-", 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a0", "2"], "+", 
           SuperscriptBox["af", "2"], "-", 
           RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["jMax", "2"], " ", "t1", " ", "t3"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["jMax", "2"], " ", 
            SuperscriptBox["t3", "2"]}], "-", 
           RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
           RowBox[{"2", " ", "jMax", " ", "vf"}]}]]}]}], ")"}]}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"t5", "\[Rule]", 
     RowBox[{
      FractionBox["1", 
       RowBox[{"2", " ", "jMax"}]], 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], " ", "a0"}], "-", 
        RowBox[{"2", " ", "jMax", " ", "t1"}], "+", 
        RowBox[{"2", " ", "jMax", " ", "t3"}], "+", 
        RowBox[{
         SqrtBox["2"], " ", 
         SqrtBox[
          RowBox[{
           SuperscriptBox["a0", "2"], "+", 
           SuperscriptBox["af", "2"], "-", 
           RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
           RowBox[{"4", " ", 
            SuperscriptBox["jMax", "2"], " ", "t1", " ", "t3"}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["jMax", "2"], " ", 
            SuperscriptBox["t3", "2"]}], "-", 
           RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
           RowBox[{"2", " ", "jMax", " ", "vf"}]}]]}]}], ")"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{3.8201480664136763`*^9, 3.820148218603908*^9, 
  3.8201493225424232`*^9, 3.8203074896585093`*^9, 3.8203109114680367`*^9, 
  3.8203271557247353`*^9, 3.820328449198423*^9, 3.8204108362865953`*^9},
 CellLabel->
  "Out[130]=",ExpressionUUID->"026f96c6-8e25-4ecd-9ee0-d8049c25b7d0"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"t1", "[", "t3", "]"}], "\[Rule]", 
    FractionBox[
     RowBox[{
      SuperscriptBox["a0", "2"], "+", 
      SuperscriptBox["af", "2"], "-", 
      RowBox[{"4", " ", "a0", " ", "jMax", " ", "t3"}], "-", 
      RowBox[{"2", " ", "jMax", " ", "v0"}], "+", 
      RowBox[{"2", " ", "jMax", " ", "vf"}], "+", 
      RowBox[{"4", " ", 
       SuperscriptBox["jMax", "2"], " ", "t3", " ", 
       TemplateBox[{"1"},
        "C"]}], "-", 
      RowBox[{"2", " ", 
       SuperscriptBox["jMax", "2"], " ", 
       SuperscriptBox[
        TemplateBox[{"1"},
         "C"], "2"]}]}], 
     RowBox[{"4", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3"}]]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.8201480664136763`*^9, 3.820148218603908*^9, 
  3.8201493225424232`*^9, 3.8203074896585093`*^9, 3.8203109114680367`*^9, 
  3.8203271557247353`*^9, 3.820328449198423*^9, 3.820410836900587*^9},
 CellLabel->
  "Out[131]=",ExpressionUUID->"9522ce7b-ab7e-40d1-aa77-77ef84ab9939"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"t1", "+", "t3", "+", "t5", "+", "t7"}], ")"}], "/.", 
         RowBox[{"t7r", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
        RowBox[{"t5r", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
       RowBox[{"{", 
        RowBox[{"t1", "->", 
         RowBox[{"t1d", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}]}], "}"}]}], ")"}], 
     "]"}], ",", "t3"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.8203262958721046`*^9, 3.8203264501766768`*^9}, {
   3.820326696341227*^9, 3.820326705297976*^9}, 3.820327231142769*^9, {
   3.8203276824494247`*^9, 3.820327703753333*^9}},
 CellLabel->"In[34]:=",ExpressionUUID->"fdf27493-61a0-48a1-a2cd-121356de341c"],

Cell[BoxData[
 RowBox[{"2", "-", 
  FractionBox[
   RowBox[{"2", " ", "jMax", " ", 
    RowBox[{"(", 
     RowBox[{"t3", "-", 
      TemplateBox[{"1"},
       "C"]}], ")"}]}], 
   SqrtBox[
    RowBox[{
     SuperscriptBox["jMax", "2"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"t3", "-", 
        TemplateBox[{"1"},
         "C"]}], ")"}], "2"]}]]]}]], "Output",
 CellChangeTimes->{{3.820326296448601*^9, 3.820326402544961*^9}, {
   3.820326434286088*^9, 3.82032645065075*^9}, {3.8203266969045553`*^9, 
   3.820326705740295*^9}, 3.820327231564172*^9, {3.8203276919691668`*^9, 
   3.820327704325389*^9}},
 CellLabel->"Out[34]=",ExpressionUUID->"3f4ab7ce-d531-44d1-a76c-b80cf9707191"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tmp", "=", 
   RowBox[{
    RowBox[{"t1d", "[", 
     RowBox[{"[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      TemplateBox[{"1"},
       "C"], "\[Rule]", "t3"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", "tmp", "]"}], ",", "CForm"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820311236074346*^9, 3.820311291553483*^9}, {
   3.82031276791503*^9, 3.820312783125237*^9}, {3.8203138621422157`*^9, 
   3.8203138741399508`*^9}, 3.8203139888931007`*^9, {3.820314026430644*^9, 
   3.82031402704445*^9}},
 CellLabel->
  "In[511]:=",ExpressionUUID->"60875d52-63bd-466d-8436-f5d9243d2f74"],

Cell[BoxData["\<\"(Power(a0,2) + Power(af,2) - 4*a0*jMax*t3 + \
2*jMax*(jMax*Power(t3,2) - v0 + vf))/(4.*Power(jMax,2)*t3)\"\>"], "Output",
 CellChangeTimes->{{3.82031121317542*^9, 3.820311291845148*^9}, {
   3.8203127686658154`*^9, 3.820312783807333*^9}, {3.8203138628355913`*^9, 
   3.820313874557353*^9}, 3.820313989375464*^9, 3.820314027868582*^9},
 CellLabel->
  "Out[512]=",ExpressionUUID->"40870306-99ce-4ee2-a3cc-3bc2d4831823"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p7", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}], ",", 
         RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
      RowBox[{"t7r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t5r", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"t1", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"t1d", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ")"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"1"},
      "C"], "\[Rule]", "t3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.820312504752842*^9, 3.820312579642996*^9}, {
  3.820312612376958*^9, 3.8203126252796593`*^9}, {3.820313084077009*^9, 
  3.820313088579298*^9}},
 CellLabel->
  "In[488]:=",ExpressionUUID->"74470ae4-6515-4c1e-a697-531c9c82f2cd"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"48", " ", 
     SuperscriptBox["jMax", "3"], " ", "t3"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a0", "4"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["af", "4"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["a0", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["af", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"48", " ", "a0", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "v0"}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["af", "2"], " ", "jMax", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "jMax", " ", 
         SuperscriptBox["t3", "2"]}], "+", "v0", "-", "vf"}], ")"}]}], "+", 
     RowBox[{"48", " ", "af", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "vf"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["af", "2"], "+", 
        RowBox[{"2", " ", "jMax", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "jMax", " ", 
            SuperscriptBox["t3", "2"]}], "-", "v0", "+", "vf"}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["jMax", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["jMax", "2"], " ", 
         SuperscriptBox["t3", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"v0", "-", "vf"}], ")"}], "2"], "+", 
        RowBox[{"4", " ", "jMax", " ", "t3", " ", 
         RowBox[{"(", 
          RowBox[{"p0", "+", 
           RowBox[{"t3", " ", 
            RowBox[{"(", 
             RowBox[{"v0", "+", "vf"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.820312498602363*^9, 3.820312527417675*^9}, {
   3.820312567485794*^9, 3.820312580299762*^9}, {3.820312612925564*^9, 
   3.82031262594932*^9}, 3.820313089256578*^9, 3.820313128254983*^9},
 CellLabel->
  "Out[488]=",ExpressionUUID->"edbcb1ef-7497-4e27-9041-4279244192b8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"p7", "/.", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"t2", "\[Rule]", "0"}], ",", 
         RowBox[{"t4", "\[Rule]", "0"}], ",", 
         RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
      RowBox[{"t7r", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
     RowBox[{"t5r", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{"t1", "\[Rule]", 
      RowBox[{"(", 
       RowBox[{"t1d", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ")"}]}], "}"}]}], "/.", 
   RowBox[{"{", 
    RowBox[{
     TemplateBox[{"1"},
      "C"], "\[Rule]", "t3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.820313030661717*^9, 3.820313071434621*^9}},
 CellLabel->
  "In[485]:=",ExpressionUUID->"aab49c1b-186c-4921-be5a-411197e871d9"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"48", " ", 
     SuperscriptBox["jMax", "3"], " ", "t3"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a0", "4"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["af", "4"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["a0", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["af", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"48", " ", "a0", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "v0"}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["af", "2"], " ", "jMax", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "jMax", " ", 
         SuperscriptBox["t3", "2"]}], "+", "v0", "-", "vf"}], ")"}]}], "+", 
     RowBox[{"48", " ", "af", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "vf"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["af", "2"], "+", 
        RowBox[{"2", " ", "jMax", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "jMax", " ", 
            SuperscriptBox["t3", "2"]}], "-", "v0", "+", "vf"}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["jMax", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["jMax", "2"], " ", 
         SuperscriptBox["t3", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"v0", "-", "vf"}], ")"}], "2"], "+", 
        RowBox[{"4", " ", "jMax", " ", "t3", " ", 
         RowBox[{"(", 
          RowBox[{"p0", "+", 
           RowBox[{"t3", " ", 
            RowBox[{"(", 
             RowBox[{"v0", "+", "vf"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.820313031520012*^9, 3.820313071959421*^9}},
 CellLabel->
  "Out[485]=",ExpressionUUID->"3a2a36bc-9448-4c8b-96da-12a65fadf973"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"resultTsp", "=", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{"Solve", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"Simplify", "[", 
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"p7", "/.", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"t2", "\[Rule]", "0"}], ",", 
               RowBox[{"t4", "\[Rule]", "0"}], ",", 
               RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
            RowBox[{"t7r", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
           RowBox[{"t5r", "[", 
            RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{"t1", "\[Rule]", 
            RowBox[{"(", 
             RowBox[{"t1d", "[", 
              RowBox[{"[", 
               RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ")"}]}], 
           "}"}]}], "/.", 
         RowBox[{"{", 
          RowBox[{
           TemplateBox[{"1"},
            "C"], "\[Rule]", "t3"}], "}"}]}], "]"}], "\[Equal]", "pf"}], ",", 
      "t3", ",", 
      RowBox[{"Quartics", "\[Rule]", "False"}], ",", 
      RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}], "\[IndentingNewLine]", 
    "}"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.820310226235965*^9, 3.820310287604726*^9}, {
   3.820310326198073*^9, 3.820310359932549*^9}, {3.820310401197764*^9, 
   3.820310402437796*^9}, {3.820310580455214*^9, 3.820310587797388*^9}, 
   3.8203108183379583`*^9, 3.820310864546274*^9, {3.820310942170804*^9, 
   3.820310954391629*^9}, {3.820312479912847*^9, 3.8203124930399942`*^9}, 
   3.820312532339363*^9, {3.8203126369563913`*^9, 3.820312659735902*^9}, {
   3.820313052340271*^9, 3.82031305625882*^9}},
 CellLabel->
  "In[486]:=",ExpressionUUID->"1ae1d73d-3872-4467-afe0-2a4285eaa8a1"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"resultTsp", "[", 
   RowBox[{"[", "1", "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p0", "\[Rule]", 
     RowBox[{"-", "3.09363"}]}], ",", 
    RowBox[{"v0", "\[Rule]", 
     RowBox[{"-", "0.244871"}]}], ",", 
    RowBox[{"a0", "\[Rule]", "0.39928"}], ",", 
    RowBox[{"pf", "\[Rule]", 
     RowBox[{"-", "2.64314"}]}], ",", 
    RowBox[{"vf", "\[Rule]", "1.21999"}], ",", 
    RowBox[{"af", "\[Rule]", "2.23185"}], ",", 
    RowBox[{"vMax", "\[Rule]", "12.6869"}], ",", 
    RowBox[{"aMax", "\[Rule]", "11.5737"}], ",", 
    RowBox[{"jMax", "\[Rule]", "9.48106"}]}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8203109746164722`*^9, 3.820310975800064*^9}, {
  3.8203123796330214`*^9, 3.82031239485714*^9}},
 CellLabel->
  "In[483]:=",ExpressionUUID->"eeb6fb04-66e9-497d-86d2-19d153d75bad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{"-", "0.09019757046459086`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", "0.5048795897236098`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.20734100962950944`"}], "-", 
      RowBox[{"0.8325782186828211`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t3", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.20734100962950944`"}], "+", 
      RowBox[{"0.8325782186828211`", " ", "\[ImaginaryI]"}]}]}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{
  3.820310976416443*^9, {3.820312378371026*^9, 3.820312418792605*^9}, {
   3.820312641458581*^9, 3.820312661479053*^9}, 3.820313058533025*^9},
 CellLabel->
  "Out[483]=",ExpressionUUID->"e1f9b46a-6ed1-410d-8b94-f5164359d144"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"tRoot", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tmpResult", "=", 
   RowBox[{"resultTsp", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "1"}], "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootFunction", "=", 
   RowBox[{"tmpResult", "[", 
    RowBox[{"[", 
     RowBox[{"tRoot", ",", "2"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   FractionBox[
    RowBox[{
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "[", 
     RowBox[{"[", "1", "]"}], "]"}], 
    RowBox[{"Last", "[", 
     RowBox[{"CoefficientList", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"rootFunction", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "[", "x", "]"}], ",", "x"}], "]"}], 
     "]"}]], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ToString", "[", 
   RowBox[{"tmp", ",", "CForm"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820310959217637*^9, 3.820310992998939*^9}, {
  3.820311083009034*^9, 3.82031110015204*^9}, {3.8203111301558447`*^9, 
  3.820311149559708*^9}, {3.82031267422526*^9, 3.8203126938159723`*^9}},
 CellLabel->
  "In[463]:=",ExpressionUUID->"ce7e4dd2-380c-4e59-9288-6575057b94dc"],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox["a0", "2"], "+", 
      SuperscriptBox["af", "2"], "+", 
      RowBox[{"2", " ", "jMax", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "v0"}], "+", "vf"}], ")"}]}]}], ")"}], "2"], 
   RowBox[{"4", " ", 
    SuperscriptBox["jMax", "4"]}]]}]], "Output",
 CellChangeTimes->{{3.820310960699957*^9, 3.820310993336852*^9}, {
  3.820311083360579*^9, 3.8203111004007473`*^9}, {3.820311130572308*^9, 
  3.820311149831209*^9}, {3.82031267242376*^9, 3.820312694076724*^9}},
 CellLabel->
  "Out[466]=",ExpressionUUID->"8f58062b-b931-42bd-8427-acf8a5a4255c"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"tmp", "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"p7", "-", "pf"}], ")"}], "/.", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"t2", "\[Rule]", "0"}], ",", 
          RowBox[{"t4", "\[Rule]", "0"}], ",", 
          RowBox[{"t6", "\[Rule]", "0"}]}], "}"}]}], "/.", 
       RowBox[{"t7r", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "/.", 
      RowBox[{"t5r", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], "/.", 
     RowBox[{"{", 
      RowBox[{"t1", "\[Rule]", 
       RowBox[{"(", 
        RowBox[{"t1d", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "1", ",", "2"}], "]"}], "]"}], ")"}]}], "}"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      TemplateBox[{"1"},
       "C"], "\[Rule]", "t3"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8203131552132587`*^9, 3.820313186083877*^9}},
 CellLabel->
  "In[491]:=",ExpressionUUID->"431bc900-2004-40c2-ab81-a63aed4ff595"],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"48", " ", 
     SuperscriptBox["jMax", "3"], " ", "t3"}]], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"3", " ", 
      SuperscriptBox["a0", "4"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["af", "4"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["a0", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"16", " ", 
      SuperscriptBox["af", "3"], " ", "jMax", " ", "t3"}], "+", 
     RowBox[{"48", " ", "a0", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "v0"}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["af", "2"], " ", "jMax", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"2", " ", "jMax", " ", 
         SuperscriptBox["t3", "2"]}], "+", "v0", "-", "vf"}], ")"}]}], "+", 
     RowBox[{"48", " ", "af", " ", 
      SuperscriptBox["jMax", "2"], " ", "t3", " ", "vf"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["a0", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["af", "2"], "+", 
        RowBox[{"2", " ", "jMax", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "jMax", " ", 
            SuperscriptBox["t3", "2"]}], "-", "v0", "+", "vf"}], ")"}]}]}], 
       ")"}]}], "-", 
     RowBox[{"12", " ", 
      SuperscriptBox["jMax", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SuperscriptBox["jMax", "2"], " ", 
         SuperscriptBox["t3", "4"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"v0", "-", "vf"}], ")"}], "2"], "+", 
        RowBox[{"4", " ", "jMax", " ", "t3", " ", 
         RowBox[{"(", 
          RowBox[{"p0", "-", "pf", "+", 
           RowBox[{"t3", " ", 
            RowBox[{"(", 
             RowBox[{"v0", "+", "vf"}], ")"}]}]}], ")"}]}]}], ")"}]}]}], 
    ")"}]}]}]], "Output",
 CellChangeTimes->{{3.820313143353652*^9, 3.820313186409289*^9}},
 CellLabel->
  "Out[491]=",ExpressionUUID->"6dd3b1e1-ea1e-4c19-ae90-592d85bc526a"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ToString", "[", 
  RowBox[{
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{"tmp", ",", "t3"}], "]"}], "]"}], ",", "CForm"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"CopyToClipboard", "[", "%", "]"}]}], "Input",
 CellChangeTimes->{{3.820313283350288*^9, 3.820313286340653*^9}},
 CellLabel->
  "In[494]:=",ExpressionUUID->"1e1d00c8-16e2-4441-8e2e-9d37bca8d931"],

Cell[BoxData["\<\"(Power(a0,4) + Power(af,4) + 2*Power(a0,2)*(Power(af,2) - \
2*jMax*(2*jMax*Power(t3,2) + v0 - vf)) + \
4*Power(af,2)*jMax*(2*jMax*Power(t3,2) - v0 + vf) + \
4*Power(jMax,2)*(3*Power(jMax,2)*Power(t3,4) + Power(v0 - vf,2) + \
4*jMax*Power(t3,2)*(v0 + vf)))/(16.*Power(jMax,3)*Power(t3,2))\"\>"], "Output",\

 CellChangeTimes->{3.820313191992317*^9, 3.820313287200824*^9},
 CellLabel->
  "Out[494]=",ExpressionUUID->"e87b983b-e7da-490e-a23b-caa2c7ac4a74"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "4"], "-", 
     RowBox[{"4", "x", 
      FractionBox["pd", "jMax"]}]}], "\[Equal]", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.820562253300253*^9, 3.82056229545183*^9}},
 CellLabel->
  "In[2460]:=",ExpressionUUID->"9a1cb538-fbe9-4b4c-b646-ed6c1ec0bb5d"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "2"}], ")"}], 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox["pd", 
        RowBox[{"1", "/", "3"}]]}], 
      SuperscriptBox["jMax", 
       RowBox[{"1", "/", "3"}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox["pd", 
        RowBox[{"1", "/", "3"}]]}], 
      SuperscriptBox["jMax", 
       RowBox[{"1", "/", "3"}]]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], 
         RowBox[{"1", "/", "3"}]], " ", 
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox["pd", 
         RowBox[{"1", "/", "3"}]]}], 
       SuperscriptBox["jMax", 
        RowBox[{"1", "/", "3"}]]]}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.820562278668207*^9, 3.820562295728676*^9}},
 CellLabel->
  "Out[2460]=",ExpressionUUID->"d3910532-eaa3-44f1-90b5-ed903549d017"]
}, Open  ]]
},
WindowSize->{918, 888},
WindowMargins->{{Automatic, -40}, {-153, Automatic}},
FrontEndVersion->"12.2 for Mac OS X x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"c8b287f8-8b4a-4e98-ab1e-df7dcd999be5"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 206, 4, 35, "Text",ExpressionUUID->"f0efc888-777d-4c66-b8e6-2db88daacc31"],
Cell[767, 26, 6936, 215, 812, "Input",ExpressionUUID->"d346b209-9dd3-47cf-8f1e-f04bc3bf980a"],
Cell[7706, 243, 8130, 195, 430, "Input",ExpressionUUID->"ccba75f7-892e-4119-93ec-41811b2e330e"],
Cell[15839, 440, 1694, 30, 311, "Text",ExpressionUUID->"e82cb2e9-b4f4-4bc2-9a74-547157d3c4dc"],
Cell[17536, 472, 249, 7, 58, "Text",ExpressionUUID->"2bb13fa1-f9ef-4a5d-ac3b-101e020ad421"],
Cell[CellGroupData[{
Cell[17810, 483, 1394, 35, 115, "Input",ExpressionUUID->"f20278fb-5b15-4c9c-bd38-9f1d3931e2f3"],
Cell[19207, 520, 1142, 16, 34, "Output",ExpressionUUID->"4cd7848d-fdf9-4f4e-b495-1bf7e99dc1bd"],
Cell[20352, 538, 4216, 100, 149, "Output",ExpressionUUID->"72d60704-2911-4ccb-8d4c-6119a0a66aa5"]
}, Open  ]],
Cell[24583, 641, 166, 3, 35, "Text",ExpressionUUID->"8d7af2fe-a47e-4ef4-b28a-db0dc764dd0f"],
Cell[CellGroupData[{
Cell[24774, 648, 2231, 51, 159, "Input",ExpressionUUID->"ca8158ca-2cc6-4c2b-92b0-ae9728cb14cd"],
Cell[27008, 701, 2428, 59, 79, "Output",ExpressionUUID->"0a94f786-574e-4852-9434-e6c9207268ec"]
}, Open  ]],
Cell[CellGroupData[{
Cell[29473, 765, 1425, 28, 94, "Input",ExpressionUUID->"02ddacce-ea40-40b5-bbc9-e4e0e8a8500b"],
Cell[30901, 795, 990, 16, 54, "Output",ExpressionUUID->"cd5c1068-df37-4f84-8783-2e31418f59b2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[31928, 816, 1671, 37, 94, "Input",ExpressionUUID->"bbf1a9de-0221-4992-b9c6-d1f769287d62"],
Cell[33602, 855, 2462, 53, 98, "Output",ExpressionUUID->"105051c1-dd97-49a1-a1ea-1856a027794e"],
Cell[36067, 910, 829, 13, 34, "Output",ExpressionUUID->"ee561e7d-9711-4560-80d9-d30648c0977e"]
}, Open  ]],
Cell[36911, 926, 217, 4, 38, "CodeText",ExpressionUUID->"3f45e156-5cf9-44e3-af10-aa1a13b499e9"],
Cell[37131, 932, 283, 8, 30, "Input",ExpressionUUID->"e818af86-de53-4897-8691-2be2441cd16a"],
Cell[CellGroupData[{
Cell[37439, 944, 2722, 75, 115, "Input",ExpressionUUID->"d8d6b366-35dd-4052-aa2e-094a5ea14d30"],
Cell[40164, 1021, 806, 16, 53, "Output",ExpressionUUID->"c9cf3bd0-d0c1-4283-a30b-fc90574f3520"],
Cell[40973, 1039, 823, 16, 54, "Output",ExpressionUUID->"8333c215-0a37-4c28-a603-fcd19508196a"],
Cell[41799, 1057, 1150, 24, 56, "Output",ExpressionUUID->"70f967be-3b0e-42d6-b07b-5d0c463699fc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[42986, 1086, 639, 17, 73, "Input",ExpressionUUID->"ba86318c-49c6-475e-8175-23998c1d35c0"],
Cell[43628, 1105, 317, 7, 54, "Output",ExpressionUUID->"d47918f5-d1be-4a71-b5a6-ecb86447e980"],
Cell[43948, 1114, 262, 4, 34, "Output",ExpressionUUID->"fb288fdc-c395-407c-abb8-789580173713"]
}, Open  ]],
Cell[CellGroupData[{
Cell[44247, 1123, 1379, 39, 159, "Input",ExpressionUUID->"8661a96e-a382-4a1f-9033-993cef60d8c3"],
Cell[45629, 1164, 1780, 51, 79, "Output",ExpressionUUID->"26f01fc3-d112-4df2-a15e-79678a1bc775"]
}, Open  ]],
Cell[CellGroupData[{
Cell[47446, 1220, 2109, 65, 94, "Input",ExpressionUUID->"d57e959b-b7e7-4c01-a8fa-026edffa41d9"],
Cell[49558, 1287, 516, 13, 54, "Output",ExpressionUUID->"b11919c9-3144-4341-aba1-0b1d8be41a19"],
Cell[50077, 1302, 432, 11, 54, "Output",ExpressionUUID->"1c12974d-0498-476d-927d-13b39c32b6c2"],
Cell[50512, 1315, 936, 23, 56, "Output",ExpressionUUID->"f685fef8-e488-40f3-869c-d77499e633dc"]
}, Open  ]],
Cell[CellGroupData[{
Cell[51485, 1343, 1544, 42, 73, "Input",ExpressionUUID->"c031ee14-cf99-44c4-b969-5d49c2e072bf"],
Cell[53032, 1387, 474, 10, 34, "Output",ExpressionUUID->"83f74dbf-bf61-4c36-b5da-59096000bc76"]
}, Open  ]],
Cell[CellGroupData[{
Cell[53543, 1402, 584, 15, 73, "Input",ExpressionUUID->"32f421af-9488-445c-9a56-fcc5c55c6037"],
Cell[54130, 1419, 791, 19, 56, "Output",ExpressionUUID->"e9690900-44cb-4a97-85a3-7c8e1662421c"],
Cell[54924, 1440, 416, 6, 56, "Output",ExpressionUUID->"846e2b30-d6d0-4e57-b203-3ccfaa6c2c9f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[55377, 1451, 571, 16, 30, "Input",ExpressionUUID->"98e5f169-5f1d-47e0-b55e-2ae66f4200cb"],
Cell[55951, 1469, 18246, 501, 762, "Output",ExpressionUUID->"8ee6fb37-c85f-48c4-aa14-1794c1a3c7c6"]
}, Open  ]],
Cell[74212, 1973, 3630, 92, 214, "Input",ExpressionUUID->"6e919ab8-7fe2-47c6-90c0-23d9f010233f"],
Cell[CellGroupData[{
Cell[77867, 2069, 800, 23, 30, "Input",ExpressionUUID->"48585b25-f917-4a21-8579-f955faf3196d"],
Cell[78670, 2094, 5214, 126, 258, "Output",ExpressionUUID->"86b769ae-d0e9-46d5-bec7-0ff43a85c15b"]
}, Open  ]],
Cell[CellGroupData[{
Cell[83921, 2225, 1652, 44, 73, "Input",ExpressionUUID->"f0e719fb-1f43-4b7b-ab13-e0030e29f802"],
Cell[85576, 2271, 389, 6, 34, "Output",ExpressionUUID->"39d1a936-3d0f-4fbf-8715-c719389e4289"]
}, Open  ]],
Cell[85980, 2280, 4103, 101, 244, "Input",ExpressionUUID->"deec1acf-7f7f-498a-a271-e1d2a4884e2c"],
Cell[CellGroupData[{
Cell[90108, 2385, 3624, 104, 157, "Input",ExpressionUUID->"76c16481-de84-4e2e-a943-429ec44acad1"],
Cell[93735, 2491, 1071, 20, 54, "Output",ExpressionUUID->"4675b0ed-5411-4e27-b784-ece8f684f923"],
Cell[94809, 2513, 987, 18, 54, "Output",ExpressionUUID->"eb011791-010b-4a86-a2e5-3017cc81a2b0"],
Cell[95799, 2533, 1491, 30, 56, "Output",ExpressionUUID->"68ed0252-2b59-470b-8053-401273051ec8"],
Cell[97293, 2565, 1292, 29, 64, "Output",ExpressionUUID->"be5f1406-07e7-49d2-b86b-8e78cb1713a9"]
}, Open  ]],
Cell[CellGroupData[{
Cell[98622, 2599, 708, 22, 30, "Input",ExpressionUUID->"861d34e3-2181-41b8-9a73-9af562bed505"],
Cell[99333, 2623, 694, 19, 56, "Output",ExpressionUUID->"a0048a6d-ac5f-4c36-a7f8-8a7117a4ed35"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100064, 2647, 936, 29, 52, "Input",ExpressionUUID->"8ce61ef8-3d6a-4ec6-b070-7abcd1cfb2c8"],
Cell[101003, 2678, 221, 6, 52, "Output",ExpressionUUID->"fdecf7ce-a690-4d2a-90bb-ba63fe9a6577"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101261, 2689, 827, 18, 73, "Input",ExpressionUUID->"2dc0fa63-a868-4783-87f2-49c1dcb40d82"],
Cell[102091, 2709, 587, 15, 53, "Output",ExpressionUUID->"2488aad7-c0fe-4f3c-b9a0-6bceaeb7422d"],
Cell[102681, 2726, 449, 7, 34, "Output",ExpressionUUID->"7d97b2e4-726d-4e74-9996-18de0eb3b62a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103167, 2738, 1577, 41, 159, "Input",ExpressionUUID->"24c1c053-80c3-4a2c-88a6-6d4c95ef0728"],
Cell[104747, 2781, 861, 22, 60, "Output",ExpressionUUID->"04df113e-12b6-4d82-83cc-fdc54fb34f30"]
}, Open  ]],
Cell[CellGroupData[{
Cell[105645, 2808, 1452, 43, 115, "Input",ExpressionUUID->"f888d31a-1a5d-4b9f-8b3d-e8a2fbe1fedd"],
Cell[107100, 2853, 1917, 54, 102, "Output",ExpressionUUID->"526ec543-ec8c-4a9d-a247-0396d8fb630c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[109054, 2912, 1878, 53, 73, "Input",ExpressionUUID->"c27c1a53-75cf-42e0-b674-3a9ffb6a0dc3"],
Cell[110935, 2967, 583, 13, 54, "Output",ExpressionUUID->"bf93046e-0f49-4485-8b45-38c284e26597"],
Cell[111521, 2982, 1114, 26, 57, "Output",ExpressionUUID->"47c327cd-74ba-487d-a735-9271fe465116"]
}, Open  ]],
Cell[CellGroupData[{
Cell[112672, 3013, 1625, 44, 73, "Input",ExpressionUUID->"8ea1a1c1-e3f2-4db8-ab7f-3f808af06c72"],
Cell[114300, 3059, 629, 12, 34, "Output",ExpressionUUID->"4c0b888b-aea4-4c4d-8da6-1ffc5f77f43f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[114966, 3076, 849, 24, 52, "Input",ExpressionUUID->"d9b81e1b-a620-4b83-b247-576167e171a3"],
Cell[115818, 3102, 42511, 1073, 2030, "Output",ExpressionUUID->"4e0cc09a-c5bc-4f3f-8873-5f55f695a4a2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[158366, 4180, 1913, 54, 73, "Input",ExpressionUUID->"a1407b25-8b1c-4678-950e-2905d2867987"],
Cell[160282, 4236, 578, 13, 54, "Output",ExpressionUUID->"950962bc-7fcf-4070-a72d-ac21f7ef17d6"],
Cell[160863, 4251, 2215, 59, 122, "Output",ExpressionUUID->"026f96c6-8e25-4ecd-9ee0-d8049c25b7d0"],
Cell[163081, 4312, 1041, 27, 57, "Output",ExpressionUUID->"9522ce7b-ab7e-40d1-aa77-77ef84ab9939"]
}, Open  ]],
Cell[CellGroupData[{
Cell[164159, 4344, 931, 24, 30, "Input",ExpressionUUID->"fdf27493-61a0-48a1-a2cd-121356de341c"],
Cell[165093, 4370, 703, 20, 58, "Output",ExpressionUUID->"3f4ab7ce-d531-44d1-a76c-b80cf9707191"]
}, Open  ]],
Cell[CellGroupData[{
Cell[165833, 4395, 807, 21, 73, "Input",ExpressionUUID->"60875d52-63bd-466d-8436-f5d9243d2f74"],
Cell[166643, 4418, 435, 6, 56, "Output",ExpressionUUID->"40870306-99ce-4ee2-a3cc-3bc2d4831823"]
}, Open  ]],
Cell[CellGroupData[{
Cell[167115, 4429, 1018, 30, 30, "Input",ExpressionUUID->"74470ae4-6515-4c1e-a697-531c9c82f2cd"],
Cell[168136, 4461, 2132, 58, 102, "Output",ExpressionUUID->"edbcb1ef-7497-4e27-9041-4279244192b8"]
}, Open  ]],
Cell[CellGroupData[{
Cell[170305, 4524, 918, 28, 30, "Input",ExpressionUUID->"aab49c1b-186c-4921-be5a-411197e871d9"],
Cell[171226, 4554, 1989, 56, 102, "Output",ExpressionUUID->"3a2a36bc-9448-4c8b-96da-12a65fadf973"]
}, Open  ]],
Cell[173230, 4613, 1829, 45, 115, "Input",ExpressionUUID->"1ae1d73d-3872-4467-afe0-2a4285eaa8a1"],
Cell[CellGroupData[{
Cell[175084, 4662, 840, 21, 52, "Input",ExpressionUUID->"eeb6fb04-66e9-497d-86d2-19d153d75bad"],
Cell[175927, 4685, 872, 23, 34, "Output",ExpressionUUID->"e1f9b46a-6ed1-410d-8b94-f5164359d144"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176836, 4713, 1455, 40, 159, "Input",ExpressionUUID->"ce7e4dd2-380c-4e59-9288-6575057b94dc"],
Cell[178294, 4755, 681, 18, 60, "Output",ExpressionUUID->"8f58062b-b931-42bd-8427-acf8a5a4255c"]
}, Open  ]],
Cell[CellGroupData[{
Cell[179012, 4778, 1029, 31, 52, "Input",ExpressionUUID->"431bc900-2004-40c2-ab81-a63aed4ff595"],
Cell[180044, 4811, 2000, 56, 102, "Output",ExpressionUUID->"6dd3b1e1-ea1e-4c19-ae90-592d85bc526a"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182081, 4872, 406, 10, 52, "Input",ExpressionUUID->"1e1d00c8-16e2-4441-8e2e-9d37bca8d931"],
Cell[182490, 4884, 471, 8, 77, "Output",ExpressionUUID->"e87b983b-e7da-490e-a23b-caa2c7ac4a74"]
}, Open  ]],
Cell[CellGroupData[{
Cell[182998, 4897, 371, 11, 51, "Input",ExpressionUUID->"9a1cb538-fbe9-4b4c-b646-ed6c1ec0bb5d"],
Cell[183372, 4910, 1353, 44, 57, "Output",ExpressionUUID->"d3910532-eaa3-44f1-90b5-ed903549d017"]
}, Open  ]]
}
]
*)

