# urdf_tutorial: Learning URDF Step by Step

 1. [Building a Visual Robot Model with URDF from Scratch](https://docs.ros.org/en/rolling/Tutorials/URDF/Building-a-Visual-Robot-Model-with-URDF-from-Scratch.html) - Learn how to build a visual model of a robot that you can view in Rviz

 1. [Building a Movable Robot Model with URDF](https://docs.ros.org/en/rolling/Tutorials/URDF/Building-a-Movable-Robot-Model-with-URDF.html) - Learn how to define movable joints in URDF

 1. [Adding Physical and Collision Properties to a URDF Model](https://docs.ros.org/en/rolling/Tutorials/URDF/Adding-Physical-and-Collision-Properties-to-a-URDF-Model.html) - Learn how to add collision and inertial properties to links, and how to add joint dynamics to joints.

 1. [Using Xacro to Clean Up a URDF File](https://docs.ros.org/en/rolling/Tutorials/URDF/Using-Xacro-to-Clean-Up-a-URDF-File.html) - Learn some tricks to reduce the amount of code in a URDF file using Xacro

See also [urdf_sim_tutorial](https://github.com/ros/urdf_sim_tutorial) for the final tutorial: [Using a URDF in Gazebo](https://wiki.ros.org/urdf/Tutorials/Using%20a%20URDF%20in%20Gazebo) - Preliminary tutorial on how to spawn and control your robot in Gazebo.
