// Copyright 1996-2021 Cyberbotics Ltd.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#define WB_ALLOW_MIXING_C_AND_CPP_API
#include <webots/light_sensor.h>
#include <webots/LightSensor.hpp>

using namespace webots;

void LightSensor::enable(int sampling_period) {
  wb_light_sensor_enable(getTag(), sampling_period);
}

void LightSensor::disable() {
  wb_light_sensor_disable(getTag());
}

int LightSensor::getSamplingPeriod() const {
  return wb_light_sensor_get_sampling_period(getTag());
}

double LightSensor::getValue() const {
  return wb_light_sensor_get_value(getTag());
}

int LightSensor::getLookupTableSize() const {
  return wb_light_sensor_get_lookup_table_size(getTag());
}

const double *LightSensor::getLookupTable() const {
  return wb_light_sensor_get_lookup_table(getTag());
}
