/*
 * Copyright (C) 2021 Open Source Robotics Foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
*/
import QtQuick 2.9
import QtQuick.Controls 2.2
import QtQuick.Controls.Material 2.1
import QtQuick.Layouts 1.3

RowLayout {
  id: shutdownButton
  width: 64
  spacing: 2
  Layout.minimumWidth: 64
  Layout.minimumHeight: 64

  /**
   * Close icon
   */
  property string closeIcon: "\u2A2F"
  
  property int tooltipDelay: 500
  property int tooltipTimeout: 1000

  /**
   * Close button
   */
  RoundButton {
    id: closeButton
    visible: true
    text: closeIcon
    checkable: true
    Layout.alignment : Qt.AlignVCenter
    Layout.minimumWidth: width
    Layout.leftMargin: 10
    onClicked: {
      ShutdownButton.OnStop()
    }
    Material.background: Material.primary
    ToolTip.visible: hovered
    ToolTip.delay: tooltipDelay
    ToolTip.timeout: tooltipTimeout
    ToolTip.text: qsTr("Quit")
  }
}
