C# DCPS API                                                            {#mainpage}
====================

[TOC]

About the C# Reference Guide                                                        {#mainpage_about}
============================

The C# Reference Guide provides details of the Vortex OpenSplice (Subscription
Paradigm for the Logical Interconnection of Concurrent Engines) Application
Programming Interfaces for the C# language.

The C# Reference Guide describes the Data Centric Publish Subscribe (DCPS)
layer. The purpose of the DCPS is the distribution of data (publish/subscribe). The
structure of the DCPS is divided into five modules. Each module consists of several
classes, which in turn generally contain several operations.

Getting started                                                                {#mainpage_gettingstarted}
===============

See the [DDS Tutorial (pdf)] (../../pdf/OpenSplice_DDSTutorial.pdf) for more information
about the DDS specification and usage, which is a good starting point if you don't know
much about DDS yet.

If you are new to C# we would recommend that you start by looking at the example
code provided in your OpenSplice installation directory as well as the documentation
in the sections below.

A summary of each example, along with build instructions can be found on the
\subpage sacs_dcpsexamples page.


How to use the C# API                                                                {#mainpage_howtouse}
=====================

The API is currently compiled on the Windows platform using Microsoft's C# compiler. A port to Linux using
the Mono framework has also been used by the opensource community, but that is not yet part of the commercially
supported releases. However, it should be possible to run the Windows DLL on Mono, since Mono is binary compatible with Windows.
The resulting deliverable is a library file called dcpssacsAssembly.dll, which you can find in the
%OSPL_HOME%/bin directory alongside all the other OpenSplice DDS product libraries.

Since the DLL is a managed assembly, it is not found by Windows using the normal PATH environment variable.
In order for the .NET framework to find a library, this library must either be copied to the same directory
location as the executable that tries to load it, or the library must be copied into the Global Assembly Cache (GAC).
For details about the global assembly cache, and how to manage it, see the Wikipedia Global Assembly Cache information.

The C# API is very similar to the other language bindings, with a couple of exceptions:

* The C# API satisfies the C# coding conventions, meaning that:
- All interfaces start with the 'I' character.
- All operations are written in CamelBack notation ('CreateTopic' instead of 'create_topic')
- Class-Attributes are not implemented by explicit getter operations, but by C# properties.
* The C# API introduces operation overloading: many operations have multiple versions with different parameters:
- Choose the operation with the minimum amount of parameters that fits your need.
- Parameters that are not passed are set to their default values.
- This removes the need for some of the special purpose macro's that represent default values for parameters.
* Constants have been defined in the classes they refer to.
- For example: the DURATION_INFINITE is a constant called 'Infinite' in the struct Duration.

To generate a C# data model from your Topic IDL definitions, use idlpp in the following way:

        idlpp -l cs -S < IDL_FILE >

Here, 'cs' represents the Csharp language, and -S represents the fact that there is no dependency on any ORB. See also 'idlpp -h'.

Current limitations of the C# API                                                {#mainpage_currentlimitations}
=================================

* idlpp is not able to generate the correct C# representation for IDL unions.
* Datatypes generated by idlpp are not always initialized to valid default values. For example,
  an array of strings is initialized to a string array holding 'null' pointers, which you need
  to assign manually before you can write the contents of your sample into the DDS.
